package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ResourceRequirementsFluentImpl<T extends ResourceRequirementsFluent<T>> extends BaseFluent<T> implements ResourceRequirementsFluent<T>{

     Map<String, Quantity> limits = new HashMap();     Map<String, Quantity> requests = new HashMap();     Map<String, Object> additionalProperties = new HashMap();
public ResourceRequirementsFluentImpl(){
    
}
public ResourceRequirementsFluentImpl( ResourceRequirements instance ){
    this.withLimits(instance.getLimits()); this.withRequests(instance.getRequests()); 
}

    public T addToLimits( String key,  Quantity value){
    if(key != null && value != null) {this.limits.put(key, value);} return (T)this;
    }
    public T addToLimits( Map<String, Quantity> map){
    if(map != null) { this.limits.putAll(map);} return (T)this;
    }
    public T removeFromLimits( String key){
    if(key != null) {this.limits.remove(key);} return (T)this;
    }
    public T removeFromLimits( Map<String, Quantity> map){
    if(map != null) { for(Object key : map.keySet()) {this.limits.remove(key);}} return (T)this;
    }
    public Map<String, Quantity> getLimits(){
    return this.limits;
    }
    public T withLimits( Map<String, Quantity> limits){
    this.limits.clear();if (limits != null) {this.limits.putAll(limits);} return (T) this;
    }
    public T addToRequests( String key,  Quantity value){
    if(key != null && value != null) {this.requests.put(key, value);} return (T)this;
    }
    public T addToRequests( Map<String, Quantity> map){
    if(map != null) { this.requests.putAll(map);} return (T)this;
    }
    public T removeFromRequests( String key){
    if(key != null) {this.requests.remove(key);} return (T)this;
    }
    public T removeFromRequests( Map<String, Quantity> map){
    if(map != null) { for(Object key : map.keySet()) {this.requests.remove(key);}} return (T)this;
    }
    public Map<String, Quantity> getRequests(){
    return this.requests;
    }
    public T withRequests( Map<String, Quantity> requests){
    this.requests.clear();if (requests != null) {this.requests.putAll(requests);} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ResourceRequirementsFluentImpl that = (ResourceRequirementsFluentImpl) o;
if (limits != null ? !limits.equals(that.limits) :that.limits != null) return false;
if (requests != null ? !requests.equals(that.requests) :that.requests != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
