package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SecretFluent<T extends SecretFluent<T>> extends Fluent<T>{


    public Secret.ApiVersion getApiVersion();    public T withApiVersion( Secret.ApiVersion apiVersion);    public T addToData( String key,  String value);    public T addToData( Map<String, String> map);    public T removeFromData( String key);    public T removeFromData( Map<String, String> map);    public Map<String, String> getData();    public T withData( Map<String, String> data);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public String getType();    public T withType( String type);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
