package io.fabric8.kubernetes.api.model.extensions;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class DaemonSetUpdateStrategyFluentImpl<T extends DaemonSetUpdateStrategyFluent<T>> extends BaseFluent<T> implements DaemonSetUpdateStrategyFluent<T>{

     VisitableBuilder<RollingUpdateDaemonSet, ?> rollingUpdate;     String type;     Map<String, Object> additionalProperties = new HashMap();
public DaemonSetUpdateStrategyFluentImpl(){
    
}
public DaemonSetUpdateStrategyFluentImpl( DaemonSetUpdateStrategy instance ){
    this.withRollingUpdate(instance.getRollingUpdate()); this.withType(instance.getType()); 
}

    public RollingUpdateDaemonSet getRollingUpdate(){
    return this.rollingUpdate!=null?this.rollingUpdate.build():null;
    }
    public T withRollingUpdate( RollingUpdateDaemonSet rollingUpdate){
    if (rollingUpdate!=null){ this.rollingUpdate= new RollingUpdateDaemonSetBuilder(rollingUpdate); _visitables.add(this.rollingUpdate);} return (T) this;
    }
    public RollingUpdateNested<T> withNewRollingUpdate(){
    return new RollingUpdateNestedImpl<T>();
    }
    public RollingUpdateNested<T> withNewRollingUpdateLike( RollingUpdateDaemonSet item){
    return new RollingUpdateNestedImpl<T>(item);
    }
    public RollingUpdateNested<T> editRollingUpdate(){
    return withNewRollingUpdateLike(getRollingUpdate());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DaemonSetUpdateStrategyFluentImpl that = (DaemonSetUpdateStrategyFluentImpl) o;
if (rollingUpdate != null ? !rollingUpdate.equals(that.rollingUpdate) :that.rollingUpdate != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class RollingUpdateNestedImpl<N> extends RollingUpdateDaemonSetFluentImpl<RollingUpdateNested<N>> implements RollingUpdateNested<N>{

        private final RollingUpdateDaemonSetBuilder builder;
    
             RollingUpdateNestedImpl (){
        this.builder = new RollingUpdateDaemonSetBuilder(this);
        }
             RollingUpdateNestedImpl ( RollingUpdateDaemonSet item){
        this.builder = new RollingUpdateDaemonSetBuilder(this, item);
        }
    
            public N endRollingUpdate(){
            return and();
        }
            public N and(){
            return (N) DaemonSetUpdateStrategyFluentImpl.this.withRollingUpdate(builder.build());
        }
    
}


}
