package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class HorizontalPodAutoscalerSpecFluentImpl<T extends HorizontalPodAutoscalerSpecFluent<T>> extends BaseFluent<T> implements HorizontalPodAutoscalerSpecFluent<T>{

     VisitableBuilder<CPUTargetUtilization, ?> cpuUtilization;     Integer maxReplicas;     Integer minReplicas;     VisitableBuilder<SubresourceReference, ?> scaleRef;     Map<String, Object> additionalProperties = new HashMap();
public HorizontalPodAutoscalerSpecFluentImpl(){
    
}
public HorizontalPodAutoscalerSpecFluentImpl( HorizontalPodAutoscalerSpec instance ){
    this.withCpuUtilization(instance.getCpuUtilization()); this.withMaxReplicas(instance.getMaxReplicas()); this.withMinReplicas(instance.getMinReplicas()); this.withScaleRef(instance.getScaleRef()); 
}

    public CPUTargetUtilization getCpuUtilization(){
    return this.cpuUtilization!=null?this.cpuUtilization.build():null;
    }
    public T withCpuUtilization( CPUTargetUtilization cpuUtilization){
    if (cpuUtilization!=null){ this.cpuUtilization= new CPUTargetUtilizationBuilder(cpuUtilization); _visitables.add(this.cpuUtilization);} return (T) this;
    }
    public CpuUtilizationNested<T> withNewCpuUtilization(){
    return new CpuUtilizationNestedImpl<T>();
    }
    public CpuUtilizationNested<T> withNewCpuUtilizationLike( CPUTargetUtilization item){
    return new CpuUtilizationNestedImpl<T>(item);
    }
    public CpuUtilizationNested<T> editCpuUtilization(){
    return withNewCpuUtilizationLike(getCpuUtilization());
    }
    public T withNewCpuUtilization( Integer targetPercentage){
    return withCpuUtilization(new CPUTargetUtilization(targetPercentage));
    }
    public Integer getMaxReplicas(){
    return this.maxReplicas;
    }
    public T withMaxReplicas( Integer maxReplicas){
    this.maxReplicas=maxReplicas; return (T) this;
    }
    public Integer getMinReplicas(){
    return this.minReplicas;
    }
    public T withMinReplicas( Integer minReplicas){
    this.minReplicas=minReplicas; return (T) this;
    }
    public SubresourceReference getScaleRef(){
    return this.scaleRef!=null?this.scaleRef.build():null;
    }
    public T withScaleRef( SubresourceReference scaleRef){
    if (scaleRef!=null){ this.scaleRef= new SubresourceReferenceBuilder(scaleRef); _visitables.add(this.scaleRef);} return (T) this;
    }
    public ScaleRefNested<T> withNewScaleRef(){
    return new ScaleRefNestedImpl<T>();
    }
    public ScaleRefNested<T> withNewScaleRefLike( SubresourceReference item){
    return new ScaleRefNestedImpl<T>(item);
    }
    public ScaleRefNested<T> editScaleRef(){
    return withNewScaleRefLike(getScaleRef());
    }
    public T withNewScaleRef( String apiVersion,  String kind,  String name,  String subresource){
    return withScaleRef(new SubresourceReference(apiVersion, kind, name, subresource));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl) o;
if (cpuUtilization != null ? !cpuUtilization.equals(that.cpuUtilization) :that.cpuUtilization != null) return false;
if (maxReplicas != null ? !maxReplicas.equals(that.maxReplicas) :that.maxReplicas != null) return false;
if (minReplicas != null ? !minReplicas.equals(that.minReplicas) :that.minReplicas != null) return false;
if (scaleRef != null ? !scaleRef.equals(that.scaleRef) :that.scaleRef != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class CpuUtilizationNestedImpl<N> extends CPUTargetUtilizationFluentImpl<CpuUtilizationNested<N>> implements CpuUtilizationNested<N>{

        private final CPUTargetUtilizationBuilder builder;
    
             CpuUtilizationNestedImpl (){
        this.builder = new CPUTargetUtilizationBuilder(this);
        }
             CpuUtilizationNestedImpl ( CPUTargetUtilization item){
        this.builder = new CPUTargetUtilizationBuilder(this, item);
        }
    
            public N and(){
            return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withCpuUtilization(builder.build());
        }
            public N endCpuUtilization(){
            return and();
        }
    
}
    public class ScaleRefNestedImpl<N> extends SubresourceReferenceFluentImpl<ScaleRefNested<N>> implements ScaleRefNested<N>{

        private final SubresourceReferenceBuilder builder;
    
             ScaleRefNestedImpl (){
        this.builder = new SubresourceReferenceBuilder(this);
        }
             ScaleRefNestedImpl ( SubresourceReference item){
        this.builder = new SubresourceReferenceBuilder(this, item);
        }
    
            public N endScaleRef(){
            return and();
        }
            public N and(){
            return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withScaleRef(builder.build());
        }
    
}


}
