package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface BuildConfigFluent<T extends BuildConfigFluent<T>> extends Fluent<T>{


    public BuildConfig.ApiVersion getApiVersion();    public T withApiVersion( BuildConfig.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public BuildConfigSpec getSpec();    public T withSpec( BuildConfigSpec spec);    public SpecNested<T> withNewSpec();    public SpecNested<T> withNewSpecLike( BuildConfigSpec item);    public SpecNested<T> editSpec();    public BuildConfigStatus getStatus();    public T withStatus( BuildConfigStatus status);    public StatusNested<T> withNewStatus();    public StatusNested<T> withNewStatusLike( BuildConfigStatus item);    public StatusNested<T> editStatus();    public T withNewStatus( Integer lastVersion);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>, BuildConfigSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>, BuildConfigStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
