package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ProjectRequestBuilder extends ProjectRequestFluentImpl<ProjectRequestBuilder> implements VisitableBuilder<ProjectRequest,ProjectRequestBuilder>{

     ProjectRequestFluent<?> fluent;
public ProjectRequestBuilder(){
    this(new ProjectRequest());
}
public ProjectRequestBuilder( ProjectRequestFluent<?> fluent ){
    this(fluent, new ProjectRequest());
}
public ProjectRequestBuilder( ProjectRequestFluent<?> fluent , ProjectRequest instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withDescription(instance.getDescription()); fluent.withDisplayName(instance.getDisplayName()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); 
}
public ProjectRequestBuilder( ProjectRequest instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withDescription(instance.getDescription()); this.withDisplayName(instance.getDisplayName()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

public EditableProjectRequest build(){
    EditableProjectRequest buildable = new EditableProjectRequest(fluent.getApiVersion(),fluent.getDescription(),fluent.getDisplayName(),fluent.getKind(),fluent.getMetadata());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ProjectRequestBuilder that = (ProjectRequestBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
