package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class TagImageHookFluentImpl<T extends TagImageHookFluent<T>> extends BaseFluent<T> implements TagImageHookFluent<T>{

     String containerName;     VisitableBuilder<ObjectReference, ?> to;     Map<String, Object> additionalProperties = new HashMap();
public TagImageHookFluentImpl(){
    
}
public TagImageHookFluentImpl( TagImageHook instance ){
    this.withContainerName(instance.getContainerName()); this.withTo(instance.getTo()); 
}

    public String getContainerName(){
    return this.containerName;
    }
    public T withContainerName( String containerName){
    this.containerName=containerName; return (T) this;
    }
    public ObjectReference getTo(){
    return this.to!=null?this.to.build():null;
    }
    public T withTo( ObjectReference to){
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.add(this.to);} return (T) this;
    }
    public ToNested<T> withNewTo(){
    return new ToNestedImpl<T>();
    }
    public ToNested<T> withNewToLike( ObjectReference item){
    return new ToNestedImpl<T>(item);
    }
    public ToNested<T> editTo(){
    return withNewToLike(getTo());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
TagImageHookFluentImpl that = (TagImageHookFluentImpl) o;
if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
if (to != null ? !to.equals(that.to) :that.to != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ToNestedImpl<N> extends ObjectReferenceFluentImpl<ToNested<N>> implements ToNested<N>{

        private final ObjectReferenceBuilder builder;
    
             ToNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ToNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) TagImageHookFluentImpl.this.withTo(builder.build());
        }
            public N endTo(){
            return and();
        }
    
}


}
