package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ContainerStateTerminatedBuilder extends ContainerStateTerminatedFluentImpl<ContainerStateTerminatedBuilder> implements VisitableBuilder<ContainerStateTerminated,ContainerStateTerminatedBuilder>{

     ContainerStateTerminatedFluent<?> fluent;
public ContainerStateTerminatedBuilder(){
    this(new ContainerStateTerminated());
}
public ContainerStateTerminatedBuilder( ContainerStateTerminatedFluent<?> fluent ){
    this(fluent, new ContainerStateTerminated());
}
public ContainerStateTerminatedBuilder( ContainerStateTerminatedFluent<?> fluent , ContainerStateTerminated instance ){
    this.fluent = fluent; fluent.withContainerID(instance.getContainerID()); fluent.withExitCode(instance.getExitCode()); fluent.withFinishedAt(instance.getFinishedAt()); fluent.withMessage(instance.getMessage()); fluent.withReason(instance.getReason()); fluent.withSignal(instance.getSignal()); fluent.withStartedAt(instance.getStartedAt()); 
}
public ContainerStateTerminatedBuilder( ContainerStateTerminated instance ){
    this.fluent = this; this.withContainerID(instance.getContainerID()); this.withExitCode(instance.getExitCode()); this.withFinishedAt(instance.getFinishedAt()); this.withMessage(instance.getMessage()); this.withReason(instance.getReason()); this.withSignal(instance.getSignal()); this.withStartedAt(instance.getStartedAt()); 
}

public EditableContainerStateTerminated build(){
    EditableContainerStateTerminated buildable = new EditableContainerStateTerminated(fluent.getContainerID(),fluent.getExitCode(),fluent.getFinishedAt(),fluent.getMessage(),fluent.getReason(),fluent.getSignal(),fluent.getStartedAt());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerStateTerminatedBuilder that = (ContainerStateTerminatedBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
