package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.List;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class DownwardAPIVolumeSourceBuilder extends DownwardAPIVolumeSourceFluentImpl<DownwardAPIVolumeSourceBuilder> implements VisitableBuilder<DownwardAPIVolumeSource,DownwardAPIVolumeSourceBuilder>{

     DownwardAPIVolumeSourceFluent<?> fluent;
public DownwardAPIVolumeSourceBuilder(){
    this(new DownwardAPIVolumeSource());
}
public DownwardAPIVolumeSourceBuilder( DownwardAPIVolumeSourceFluent<?> fluent ){
    this(fluent, new DownwardAPIVolumeSource());
}
public DownwardAPIVolumeSourceBuilder( DownwardAPIVolumeSourceFluent<?> fluent , DownwardAPIVolumeSource instance ){
    this.fluent = fluent; fluent.withItems(instance.getItems()); 
}
public DownwardAPIVolumeSourceBuilder( DownwardAPIVolumeSource instance ){
    this.fluent = this; this.withItems(instance.getItems()); 
}

public EditableDownwardAPIVolumeSource build(){
    EditableDownwardAPIVolumeSource buildable = new EditableDownwardAPIVolumeSource(fluent.getItems());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DownwardAPIVolumeSourceBuilder that = (DownwardAPIVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
