
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "BaseKubernetesList",
    "Binding",
    "BuildConfigList",
    "BuildList",
    "BuildRequest",
    "ClusterPolicy",
    "ClusterPolicyBinding",
    "ClusterPolicyBindingList",
    "ClusterPolicyList",
    "ClusterRoleBinding",
    "ClusterRoleBindingList",
    "ComponentStatusList",
    "Config",
    "ConfigMap",
    "ConfigMapList",
    "ContainerStatus",
    "DaemonSet",
    "DaemonSetList",
    "DeleteOptions",
    "Deployment",
    "DeploymentConfigList",
    "DeploymentList",
    "Endpoints",
    "EndpointsList",
    "EnvVar",
    "EventList",
    "Group",
    "GroupList",
    "HorizontalPodAutoscaler",
    "HorizontalPodAutoscalerList",
    "Identity",
    "IdentityList",
    "ImageList",
    "ImageStreamList",
    "Ingress",
    "IngressList",
    "Job",
    "JobList",
    "LimitRangeList",
    "ListMeta",
    "LocalSubjectAccessReview",
    "Namespace",
    "NamespaceList",
    "Node",
    "NodeList",
    "OAuthAccessToken",
    "OAuthAccessTokenList",
    "OAuthAuthorizeToken",
    "OAuthAuthorizeTokenList",
    "OAuthClient",
    "OAuthClientAuthorization",
    "OAuthClientAuthorizationList",
    "OAuthClientList",
    "ObjectMeta",
    "PersistentVolume",
    "PersistentVolumeClaim",
    "PersistentVolumeClaimList",
    "PersistentVolumeList",
    "PodList",
    "PodTemplateList",
    "Policy",
    "PolicyBinding",
    "PolicyBindingList",
    "PolicyList",
    "Project",
    "ProjectList",
    "ProjectRequest",
    "Quantity",
    "ReplicationControllerList",
    "ResourceQuota",
    "ResourceQuotaList",
    "Role",
    "RoleBinding",
    "RoleBindingList",
    "RoleList",
    "RootPaths",
    "RouteList",
    "Scale",
    "Secret",
    "SecretList",
    "SecurityContextConstraints",
    "SecurityContextConstraintsList",
    "ServiceAccount",
    "ServiceAccountList",
    "ServiceList",
    "Status",
    "SubjectAccessReview",
    "SubjectAccessReviewResponse",
    "TagEvent",
    "Template",
    "TemplateList",
    "ThirdPartyResource",
    "ThirdPartyResourceList",
    "User",
    "UserList",
    "WatchEvent"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    @Valid
    private io.fabric8.kubernetes.api.model.BaseKubernetesList BaseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("Binding")
    @Valid
    private io.fabric8.kubernetes.api.model.Binding Binding;
    /**
     * 
     * 
     */
    @JsonProperty("BuildConfigList")
    @Valid
    private io.fabric8.openshift.api.model.BuildConfigList BuildConfigList;
    /**
     * 
     * 
     */
    @JsonProperty("BuildList")
    @Valid
    private io.fabric8.openshift.api.model.BuildList BuildList;
    /**
     * 
     * 
     */
    @JsonProperty("BuildRequest")
    @Valid
    private io.fabric8.openshift.api.model.BuildRequest BuildRequest;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterPolicy")
    @Valid
    private io.fabric8.openshift.api.model.ClusterPolicy ClusterPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterPolicyBinding")
    @Valid
    private io.fabric8.openshift.api.model.ClusterPolicyBinding ClusterPolicyBinding;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterPolicyBindingList")
    @Valid
    private io.fabric8.openshift.api.model.ClusterPolicyBindingList ClusterPolicyBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterPolicyList")
    @Valid
    private io.fabric8.openshift.api.model.ClusterPolicyList ClusterPolicyList;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterRoleBinding")
    @Valid
    private io.fabric8.openshift.api.model.ClusterRoleBinding ClusterRoleBinding;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterRoleBindingList")
    @Valid
    private io.fabric8.openshift.api.model.ClusterRoleBindingList ClusterRoleBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("ComponentStatusList")
    @Valid
    private io.fabric8.kubernetes.api.model.ComponentStatusList ComponentStatusList;
    /**
     * 
     * 
     */
    @JsonProperty("Config")
    @Valid
    private io.fabric8.kubernetes.api.model.Config Config;
    /**
     * 
     * 
     */
    @JsonProperty("ConfigMap")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.ConfigMap ConfigMap;
    /**
     * 
     * 
     */
    @JsonProperty("ConfigMapList")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.ConfigMapList ConfigMapList;
    /**
     * 
     * 
     */
    @JsonProperty("ContainerStatus")
    @Valid
    private io.fabric8.kubernetes.api.model.ContainerStatus ContainerStatus;
    /**
     * 
     * 
     */
    @JsonProperty("DaemonSet")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.DaemonSet DaemonSet;
    /**
     * 
     * 
     */
    @JsonProperty("DaemonSetList")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.DaemonSetList DaemonSetList;
    /**
     * 
     * 
     */
    @JsonProperty("DeleteOptions")
    @Valid
    private io.fabric8.kubernetes.api.model.DeleteOptions DeleteOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Deployment")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.Deployment Deployment;
    /**
     * 
     * 
     */
    @JsonProperty("DeploymentConfigList")
    @Valid
    private io.fabric8.openshift.api.model.DeploymentConfigList DeploymentConfigList;
    /**
     * 
     * 
     */
    @JsonProperty("DeploymentList")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.DeploymentList DeploymentList;
    /**
     * 
     * 
     */
    @JsonProperty("Endpoints")
    @Valid
    private io.fabric8.kubernetes.api.model.Endpoints Endpoints;
    /**
     * 
     * 
     */
    @JsonProperty("EndpointsList")
    @Valid
    private io.fabric8.kubernetes.api.model.EndpointsList EndpointsList;
    /**
     * 
     * 
     */
    @JsonProperty("EnvVar")
    @Valid
    private io.fabric8.kubernetes.api.model.EnvVar EnvVar;
    /**
     * 
     * 
     */
    @JsonProperty("EventList")
    @Valid
    private io.fabric8.kubernetes.api.model.EventList EventList;
    /**
     * 
     * 
     */
    @JsonProperty("Group")
    @Valid
    private io.fabric8.openshift.api.model.Group Group;
    /**
     * 
     * 
     */
    @JsonProperty("GroupList")
    @Valid
    private io.fabric8.openshift.api.model.GroupList GroupList;
    /**
     * 
     * 
     */
    @JsonProperty("HorizontalPodAutoscaler")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler HorizontalPodAutoscaler;
    /**
     * 
     * 
     */
    @JsonProperty("HorizontalPodAutoscalerList")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList HorizontalPodAutoscalerList;
    /**
     * 
     * 
     */
    @JsonProperty("Identity")
    @Valid
    private io.fabric8.openshift.api.model.Identity Identity;
    /**
     * 
     * 
     */
    @JsonProperty("IdentityList")
    @Valid
    private io.fabric8.openshift.api.model.IdentityList IdentityList;
    /**
     * 
     * 
     */
    @JsonProperty("ImageList")
    @Valid
    private io.fabric8.openshift.api.model.ImageList ImageList;
    /**
     * 
     * 
     */
    @JsonProperty("ImageStreamList")
    @Valid
    private io.fabric8.openshift.api.model.ImageStreamList ImageStreamList;
    /**
     * 
     * 
     */
    @JsonProperty("Ingress")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.Ingress Ingress;
    /**
     * 
     * 
     */
    @JsonProperty("IngressList")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.IngressList IngressList;
    /**
     * 
     * 
     */
    @JsonProperty("Job")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.Job Job;
    /**
     * 
     * 
     */
    @JsonProperty("JobList")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.JobList JobList;
    /**
     * 
     * 
     */
    @JsonProperty("LimitRangeList")
    @Valid
    private io.fabric8.kubernetes.api.model.LimitRangeList LimitRangeList;
    /**
     * 
     * 
     */
    @JsonProperty("ListMeta")
    @Valid
    private io.fabric8.kubernetes.api.model.ListMeta ListMeta;
    /**
     * 
     * 
     */
    @JsonProperty("LocalSubjectAccessReview")
    @Valid
    private io.fabric8.openshift.api.model.LocalSubjectAccessReview LocalSubjectAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("Namespace")
    @Valid
    private io.fabric8.kubernetes.api.model.Namespace Namespace;
    /**
     * 
     * 
     */
    @JsonProperty("NamespaceList")
    @Valid
    private io.fabric8.kubernetes.api.model.NamespaceList NamespaceList;
    /**
     * 
     * 
     */
    @JsonProperty("Node")
    @Valid
    private io.fabric8.kubernetes.api.model.Node Node;
    /**
     * 
     * 
     */
    @JsonProperty("NodeList")
    @Valid
    private io.fabric8.kubernetes.api.model.NodeList NodeList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAccessToken")
    @Valid
    private io.fabric8.openshift.api.model.OAuthAccessToken OAuthAccessToken;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAccessTokenList")
    @Valid
    private io.fabric8.openshift.api.model.OAuthAccessTokenList OAuthAccessTokenList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAuthorizeToken")
    @Valid
    private io.fabric8.openshift.api.model.OAuthAuthorizeToken OAuthAuthorizeToken;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAuthorizeTokenList")
    @Valid
    private io.fabric8.openshift.api.model.OAuthAuthorizeTokenList OAuthAuthorizeTokenList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClient")
    @Valid
    private io.fabric8.openshift.api.model.OAuthClient OAuthClient;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClientAuthorization")
    @Valid
    private io.fabric8.openshift.api.model.OAuthClientAuthorization OAuthClientAuthorization;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClientAuthorizationList")
    @Valid
    private io.fabric8.openshift.api.model.OAuthClientAuthorizationList OAuthClientAuthorizationList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClientList")
    @Valid
    private io.fabric8.openshift.api.model.OAuthClientList OAuthClientList;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    @Valid
    private io.fabric8.kubernetes.api.model.ObjectMeta ObjectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolume")
    @Valid
    private io.fabric8.kubernetes.api.model.PersistentVolume PersistentVolume;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolumeClaim")
    @Valid
    private io.fabric8.kubernetes.api.model.PersistentVolumeClaim PersistentVolumeClaim;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolumeClaimList")
    @Valid
    private io.fabric8.kubernetes.api.model.PersistentVolumeClaimList PersistentVolumeClaimList;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolumeList")
    @Valid
    private io.fabric8.kubernetes.api.model.PersistentVolumeList PersistentVolumeList;
    /**
     * 
     * 
     */
    @JsonProperty("PodList")
    @Valid
    private io.fabric8.kubernetes.api.model.PodList PodList;
    /**
     * 
     * 
     */
    @JsonProperty("PodTemplateList")
    @Valid
    private io.fabric8.kubernetes.api.model.PodTemplateList PodTemplateList;
    /**
     * 
     * 
     */
    @JsonProperty("Policy")
    @Valid
    private io.fabric8.openshift.api.model.Policy Policy;
    /**
     * 
     * 
     */
    @JsonProperty("PolicyBinding")
    @Valid
    private io.fabric8.openshift.api.model.PolicyBinding PolicyBinding;
    /**
     * 
     * 
     */
    @JsonProperty("PolicyBindingList")
    @Valid
    private io.fabric8.openshift.api.model.PolicyBindingList PolicyBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("PolicyList")
    @Valid
    private io.fabric8.openshift.api.model.PolicyList PolicyList;
    /**
     * 
     * 
     */
    @JsonProperty("Project")
    @Valid
    private io.fabric8.openshift.api.model.Project Project;
    /**
     * 
     * 
     */
    @JsonProperty("ProjectList")
    @Valid
    private io.fabric8.openshift.api.model.ProjectList ProjectList;
    /**
     * 
     * 
     */
    @JsonProperty("ProjectRequest")
    @Valid
    private io.fabric8.openshift.api.model.ProjectRequest ProjectRequest;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    @Valid
    private io.fabric8.kubernetes.api.model.Quantity Quantity;
    /**
     * 
     * 
     */
    @JsonProperty("ReplicationControllerList")
    @Valid
    private io.fabric8.kubernetes.api.model.ReplicationControllerList ReplicationControllerList;
    /**
     * 
     * 
     */
    @JsonProperty("ResourceQuota")
    @Valid
    private io.fabric8.kubernetes.api.model.ResourceQuota ResourceQuota;
    /**
     * 
     * 
     */
    @JsonProperty("ResourceQuotaList")
    @Valid
    private io.fabric8.kubernetes.api.model.ResourceQuotaList ResourceQuotaList;
    /**
     * 
     * 
     */
    @JsonProperty("Role")
    @Valid
    private io.fabric8.openshift.api.model.Role Role;
    /**
     * 
     * 
     */
    @JsonProperty("RoleBinding")
    @Valid
    private io.fabric8.openshift.api.model.RoleBinding RoleBinding;
    /**
     * 
     * 
     */
    @JsonProperty("RoleBindingList")
    @Valid
    private io.fabric8.openshift.api.model.RoleBindingList RoleBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("RoleList")
    @Valid
    private io.fabric8.openshift.api.model.RoleList RoleList;
    /**
     * 
     * 
     */
    @JsonProperty("RootPaths")
    @Valid
    private io.fabric8.kubernetes.api.model.RootPaths RootPaths;
    /**
     * 
     * 
     */
    @JsonProperty("RouteList")
    @Valid
    private io.fabric8.openshift.api.model.RouteList RouteList;
    /**
     * 
     * 
     */
    @JsonProperty("Scale")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.Scale Scale;
    /**
     * 
     * 
     */
    @JsonProperty("Secret")
    @Valid
    private io.fabric8.kubernetes.api.model.Secret Secret;
    /**
     * 
     * 
     */
    @JsonProperty("SecretList")
    @Valid
    private io.fabric8.kubernetes.api.model.SecretList SecretList;
    /**
     * 
     * 
     */
    @JsonProperty("SecurityContextConstraints")
    @Valid
    private io.fabric8.kubernetes.api.model.SecurityContextConstraints SecurityContextConstraints;
    /**
     * 
     * 
     */
    @JsonProperty("SecurityContextConstraintsList")
    @Valid
    private io.fabric8.kubernetes.api.model.SecurityContextConstraintsList SecurityContextConstraintsList;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceAccount")
    @Valid
    private io.fabric8.kubernetes.api.model.ServiceAccount ServiceAccount;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceAccountList")
    @Valid
    private io.fabric8.kubernetes.api.model.ServiceAccountList ServiceAccountList;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceList")
    @Valid
    private io.fabric8.kubernetes.api.model.ServiceList ServiceList;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    @Valid
    private io.fabric8.kubernetes.api.model.Status Status;
    /**
     * 
     * 
     */
    @JsonProperty("SubjectAccessReview")
    @Valid
    private io.fabric8.openshift.api.model.SubjectAccessReview SubjectAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("SubjectAccessReviewResponse")
    @Valid
    private io.fabric8.openshift.api.model.SubjectAccessReviewResponse SubjectAccessReviewResponse;
    /**
     * 
     * 
     */
    @JsonProperty("TagEvent")
    @Valid
    private io.fabric8.openshift.api.model.TagEvent TagEvent;
    /**
     * 
     * 
     */
    @JsonProperty("Template")
    @Valid
    private io.fabric8.openshift.api.model.Template Template;
    /**
     * 
     * 
     */
    @JsonProperty("TemplateList")
    @Valid
    private io.fabric8.openshift.api.model.TemplateList TemplateList;
    /**
     * 
     * 
     */
    @JsonProperty("ThirdPartyResource")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource ThirdPartyResource;
    /**
     * 
     * 
     */
    @JsonProperty("ThirdPartyResourceList")
    @Valid
    private io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList ThirdPartyResourceList;
    /**
     * 
     * 
     */
    @JsonProperty("User")
    @Valid
    private io.fabric8.openshift.api.model.User User;
    /**
     * 
     * 
     */
    @JsonProperty("UserList")
    @Valid
    private io.fabric8.openshift.api.model.UserList UserList;
    /**
     * 
     * 
     */
    @JsonProperty("WatchEvent")
    @Valid
    private io.fabric8.kubernetes.api.model.WatchEvent WatchEvent;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param Policy
     * @param PersistentVolumeClaimList
     * @param ClusterRoleBinding
     * @param Node
     * @param Deployment
     * @param IdentityList
     * @param RouteList
     * @param PersistentVolumeList
     * @param Template
     * @param OAuthAuthorizeTokenList
     * @param ContainerStatus
     * @param ClusterPolicyList
     * @param GroupList
     * @param BaseKubernetesList
     * @param EnvVar
     * @param RoleBinding
     * @param Identity
     * @param Job
     * @param Binding
     * @param Status
     * @param DeleteOptions
     * @param TagEvent
     * @param RoleList
     * @param ServiceList
     * @param NodeList
     * @param ImageStreamList
     * @param Ingress
     * @param BuildRequest
     * @param Namespace
     * @param OAuthAuthorizeToken
     * @param Role
     * @param Secret
     * @param Project
     * @param ProjectRequest
     * @param HorizontalPodAutoscaler
     * @param DaemonSet
     * @param OAuthAccessToken
     * @param PersistentVolumeClaim
     * @param OAuthClientAuthorization
     * @param ServiceAccountList
     * @param BuildConfigList
     * @param ConfigMapList
     * @param Group
     * @param ServiceAccount
     * @param ResourceQuotaList
     * @param TemplateList
     * @param User
     * @param SecretList
     * @param OAuthClient
     * @param ComponentStatusList
     * @param Config
     * @param ThirdPartyResource
     * @param IngressList
     * @param SubjectAccessReview
     * @param LimitRangeList
     * @param NamespaceList
     * @param Endpoints
     * @param HorizontalPodAutoscalerList
     * @param DaemonSetList
     * @param DeploymentList
     * @param OAuthClientAuthorizationList
     * @param OAuthClientList
     * @param ResourceQuota
     * @param ThirdPartyResourceList
     * @param ProjectList
     * @param PolicyList
     * @param ClusterPolicyBinding
     * @param JobList
     * @param WatchEvent
     * @param ClusterPolicy
     * @param UserList
     * @param DeploymentConfigList
     * @param ReplicationControllerList
     * @param EndpointsList
     * @param BuildList
     * @param ObjectMeta
     * @param ClusterRoleBindingList
     * @param PodList
     * @param ClusterPolicyBindingList
     * @param ConfigMap
     * @param RootPaths
     * @param SecurityContextConstraintsList
     * @param SecurityContextConstraints
     * @param Quantity
     * @param Scale
     * @param LocalSubjectAccessReview
     * @param PolicyBinding
     * @param ImageList
     * @param ListMeta
     * @param OAuthAccessTokenList
     * @param PolicyBindingList
     * @param SubjectAccessReviewResponse
     * @param EventList
     * @param PodTemplateList
     * @param RoleBindingList
     * @param PersistentVolume
     */
    public KubeSchema(io.fabric8.kubernetes.api.model.BaseKubernetesList BaseKubernetesList, io.fabric8.kubernetes.api.model.Binding Binding, io.fabric8.openshift.api.model.BuildConfigList BuildConfigList, io.fabric8.openshift.api.model.BuildList BuildList, io.fabric8.openshift.api.model.BuildRequest BuildRequest, io.fabric8.openshift.api.model.ClusterPolicy ClusterPolicy, io.fabric8.openshift.api.model.ClusterPolicyBinding ClusterPolicyBinding, io.fabric8.openshift.api.model.ClusterPolicyBindingList ClusterPolicyBindingList, io.fabric8.openshift.api.model.ClusterPolicyList ClusterPolicyList, io.fabric8.openshift.api.model.ClusterRoleBinding ClusterRoleBinding, io.fabric8.openshift.api.model.ClusterRoleBindingList ClusterRoleBindingList, io.fabric8.kubernetes.api.model.ComponentStatusList ComponentStatusList, io.fabric8.kubernetes.api.model.Config Config, io.fabric8.kubernetes.api.model.extensions.ConfigMap ConfigMap, io.fabric8.kubernetes.api.model.extensions.ConfigMapList ConfigMapList, io.fabric8.kubernetes.api.model.ContainerStatus ContainerStatus, io.fabric8.kubernetes.api.model.extensions.DaemonSet DaemonSet, io.fabric8.kubernetes.api.model.extensions.DaemonSetList DaemonSetList, io.fabric8.kubernetes.api.model.DeleteOptions DeleteOptions, io.fabric8.kubernetes.api.model.extensions.Deployment Deployment, io.fabric8.openshift.api.model.DeploymentConfigList DeploymentConfigList, io.fabric8.kubernetes.api.model.extensions.DeploymentList DeploymentList, io.fabric8.kubernetes.api.model.Endpoints Endpoints, io.fabric8.kubernetes.api.model.EndpointsList EndpointsList, io.fabric8.kubernetes.api.model.EnvVar EnvVar, io.fabric8.kubernetes.api.model.EventList EventList, io.fabric8.openshift.api.model.Group Group, io.fabric8.openshift.api.model.GroupList GroupList, io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler HorizontalPodAutoscaler, io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList HorizontalPodAutoscalerList, io.fabric8.openshift.api.model.Identity Identity, io.fabric8.openshift.api.model.IdentityList IdentityList, io.fabric8.openshift.api.model.ImageList ImageList, io.fabric8.openshift.api.model.ImageStreamList ImageStreamList, io.fabric8.kubernetes.api.model.extensions.Ingress Ingress, io.fabric8.kubernetes.api.model.extensions.IngressList IngressList, io.fabric8.kubernetes.api.model.extensions.Job Job, io.fabric8.kubernetes.api.model.extensions.JobList JobList, io.fabric8.kubernetes.api.model.LimitRangeList LimitRangeList, io.fabric8.kubernetes.api.model.ListMeta ListMeta, io.fabric8.openshift.api.model.LocalSubjectAccessReview LocalSubjectAccessReview, io.fabric8.kubernetes.api.model.Namespace Namespace, io.fabric8.kubernetes.api.model.NamespaceList NamespaceList, io.fabric8.kubernetes.api.model.Node Node, io.fabric8.kubernetes.api.model.NodeList NodeList, io.fabric8.openshift.api.model.OAuthAccessToken OAuthAccessToken, io.fabric8.openshift.api.model.OAuthAccessTokenList OAuthAccessTokenList, io.fabric8.openshift.api.model.OAuthAuthorizeToken OAuthAuthorizeToken, io.fabric8.openshift.api.model.OAuthAuthorizeTokenList OAuthAuthorizeTokenList, io.fabric8.openshift.api.model.OAuthClient OAuthClient, io.fabric8.openshift.api.model.OAuthClientAuthorization OAuthClientAuthorization, io.fabric8.openshift.api.model.OAuthClientAuthorizationList OAuthClientAuthorizationList, io.fabric8.openshift.api.model.OAuthClientList OAuthClientList, io.fabric8.kubernetes.api.model.ObjectMeta ObjectMeta, io.fabric8.kubernetes.api.model.PersistentVolume PersistentVolume, io.fabric8.kubernetes.api.model.PersistentVolumeClaim PersistentVolumeClaim, io.fabric8.kubernetes.api.model.PersistentVolumeClaimList PersistentVolumeClaimList, io.fabric8.kubernetes.api.model.PersistentVolumeList PersistentVolumeList, io.fabric8.kubernetes.api.model.PodList PodList, io.fabric8.kubernetes.api.model.PodTemplateList PodTemplateList, io.fabric8.openshift.api.model.Policy Policy, io.fabric8.openshift.api.model.PolicyBinding PolicyBinding, io.fabric8.openshift.api.model.PolicyBindingList PolicyBindingList, io.fabric8.openshift.api.model.PolicyList PolicyList, io.fabric8.openshift.api.model.Project Project, io.fabric8.openshift.api.model.ProjectList ProjectList, io.fabric8.openshift.api.model.ProjectRequest ProjectRequest, io.fabric8.kubernetes.api.model.Quantity Quantity, io.fabric8.kubernetes.api.model.ReplicationControllerList ReplicationControllerList, io.fabric8.kubernetes.api.model.ResourceQuota ResourceQuota, io.fabric8.kubernetes.api.model.ResourceQuotaList ResourceQuotaList, io.fabric8.openshift.api.model.Role Role, io.fabric8.openshift.api.model.RoleBinding RoleBinding, io.fabric8.openshift.api.model.RoleBindingList RoleBindingList, io.fabric8.openshift.api.model.RoleList RoleList, io.fabric8.kubernetes.api.model.RootPaths RootPaths, io.fabric8.openshift.api.model.RouteList RouteList, io.fabric8.kubernetes.api.model.extensions.Scale Scale, io.fabric8.kubernetes.api.model.Secret Secret, io.fabric8.kubernetes.api.model.SecretList SecretList, io.fabric8.kubernetes.api.model.SecurityContextConstraints SecurityContextConstraints, io.fabric8.kubernetes.api.model.SecurityContextConstraintsList SecurityContextConstraintsList, io.fabric8.kubernetes.api.model.ServiceAccount ServiceAccount, io.fabric8.kubernetes.api.model.ServiceAccountList ServiceAccountList, io.fabric8.kubernetes.api.model.ServiceList ServiceList, io.fabric8.kubernetes.api.model.Status Status, io.fabric8.openshift.api.model.SubjectAccessReview SubjectAccessReview, io.fabric8.openshift.api.model.SubjectAccessReviewResponse SubjectAccessReviewResponse, io.fabric8.openshift.api.model.TagEvent TagEvent, io.fabric8.openshift.api.model.Template Template, io.fabric8.openshift.api.model.TemplateList TemplateList, io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource ThirdPartyResource, io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList ThirdPartyResourceList, io.fabric8.openshift.api.model.User User, io.fabric8.openshift.api.model.UserList UserList, io.fabric8.kubernetes.api.model.WatchEvent WatchEvent) {
        this.BaseKubernetesList = BaseKubernetesList;
        this.Binding = Binding;
        this.BuildConfigList = BuildConfigList;
        this.BuildList = BuildList;
        this.BuildRequest = BuildRequest;
        this.ClusterPolicy = ClusterPolicy;
        this.ClusterPolicyBinding = ClusterPolicyBinding;
        this.ClusterPolicyBindingList = ClusterPolicyBindingList;
        this.ClusterPolicyList = ClusterPolicyList;
        this.ClusterRoleBinding = ClusterRoleBinding;
        this.ClusterRoleBindingList = ClusterRoleBindingList;
        this.ComponentStatusList = ComponentStatusList;
        this.Config = Config;
        this.ConfigMap = ConfigMap;
        this.ConfigMapList = ConfigMapList;
        this.ContainerStatus = ContainerStatus;
        this.DaemonSet = DaemonSet;
        this.DaemonSetList = DaemonSetList;
        this.DeleteOptions = DeleteOptions;
        this.Deployment = Deployment;
        this.DeploymentConfigList = DeploymentConfigList;
        this.DeploymentList = DeploymentList;
        this.Endpoints = Endpoints;
        this.EndpointsList = EndpointsList;
        this.EnvVar = EnvVar;
        this.EventList = EventList;
        this.Group = Group;
        this.GroupList = GroupList;
        this.HorizontalPodAutoscaler = HorizontalPodAutoscaler;
        this.HorizontalPodAutoscalerList = HorizontalPodAutoscalerList;
        this.Identity = Identity;
        this.IdentityList = IdentityList;
        this.ImageList = ImageList;
        this.ImageStreamList = ImageStreamList;
        this.Ingress = Ingress;
        this.IngressList = IngressList;
        this.Job = Job;
        this.JobList = JobList;
        this.LimitRangeList = LimitRangeList;
        this.ListMeta = ListMeta;
        this.LocalSubjectAccessReview = LocalSubjectAccessReview;
        this.Namespace = Namespace;
        this.NamespaceList = NamespaceList;
        this.Node = Node;
        this.NodeList = NodeList;
        this.OAuthAccessToken = OAuthAccessToken;
        this.OAuthAccessTokenList = OAuthAccessTokenList;
        this.OAuthAuthorizeToken = OAuthAuthorizeToken;
        this.OAuthAuthorizeTokenList = OAuthAuthorizeTokenList;
        this.OAuthClient = OAuthClient;
        this.OAuthClientAuthorization = OAuthClientAuthorization;
        this.OAuthClientAuthorizationList = OAuthClientAuthorizationList;
        this.OAuthClientList = OAuthClientList;
        this.ObjectMeta = ObjectMeta;
        this.PersistentVolume = PersistentVolume;
        this.PersistentVolumeClaim = PersistentVolumeClaim;
        this.PersistentVolumeClaimList = PersistentVolumeClaimList;
        this.PersistentVolumeList = PersistentVolumeList;
        this.PodList = PodList;
        this.PodTemplateList = PodTemplateList;
        this.Policy = Policy;
        this.PolicyBinding = PolicyBinding;
        this.PolicyBindingList = PolicyBindingList;
        this.PolicyList = PolicyList;
        this.Project = Project;
        this.ProjectList = ProjectList;
        this.ProjectRequest = ProjectRequest;
        this.Quantity = Quantity;
        this.ReplicationControllerList = ReplicationControllerList;
        this.ResourceQuota = ResourceQuota;
        this.ResourceQuotaList = ResourceQuotaList;
        this.Role = Role;
        this.RoleBinding = RoleBinding;
        this.RoleBindingList = RoleBindingList;
        this.RoleList = RoleList;
        this.RootPaths = RootPaths;
        this.RouteList = RouteList;
        this.Scale = Scale;
        this.Secret = Secret;
        this.SecretList = SecretList;
        this.SecurityContextConstraints = SecurityContextConstraints;
        this.SecurityContextConstraintsList = SecurityContextConstraintsList;
        this.ServiceAccount = ServiceAccount;
        this.ServiceAccountList = ServiceAccountList;
        this.ServiceList = ServiceList;
        this.Status = Status;
        this.SubjectAccessReview = SubjectAccessReview;
        this.SubjectAccessReviewResponse = SubjectAccessReviewResponse;
        this.TagEvent = TagEvent;
        this.Template = Template;
        this.TemplateList = TemplateList;
        this.ThirdPartyResource = ThirdPartyResource;
        this.ThirdPartyResourceList = ThirdPartyResourceList;
        this.User = User;
        this.UserList = UserList;
        this.WatchEvent = WatchEvent;
    }

    /**
     * 
     * 
     * @return
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public io.fabric8.kubernetes.api.model.BaseKubernetesList getBaseKubernetesList() {
        return BaseKubernetesList;
    }

    /**
     * 
     * 
     * @param BaseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(io.fabric8.kubernetes.api.model.BaseKubernetesList BaseKubernetesList) {
        this.BaseKubernetesList = BaseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The Binding
     */
    @JsonProperty("Binding")
    public io.fabric8.kubernetes.api.model.Binding getBinding() {
        return Binding;
    }

    /**
     * 
     * 
     * @param Binding
     *     The Binding
     */
    @JsonProperty("Binding")
    public void setBinding(io.fabric8.kubernetes.api.model.Binding Binding) {
        this.Binding = Binding;
    }

    /**
     * 
     * 
     * @return
     *     The BuildConfigList
     */
    @JsonProperty("BuildConfigList")
    public io.fabric8.openshift.api.model.BuildConfigList getBuildConfigList() {
        return BuildConfigList;
    }

    /**
     * 
     * 
     * @param BuildConfigList
     *     The BuildConfigList
     */
    @JsonProperty("BuildConfigList")
    public void setBuildConfigList(io.fabric8.openshift.api.model.BuildConfigList BuildConfigList) {
        this.BuildConfigList = BuildConfigList;
    }

    /**
     * 
     * 
     * @return
     *     The BuildList
     */
    @JsonProperty("BuildList")
    public io.fabric8.openshift.api.model.BuildList getBuildList() {
        return BuildList;
    }

    /**
     * 
     * 
     * @param BuildList
     *     The BuildList
     */
    @JsonProperty("BuildList")
    public void setBuildList(io.fabric8.openshift.api.model.BuildList BuildList) {
        this.BuildList = BuildList;
    }

    /**
     * 
     * 
     * @return
     *     The BuildRequest
     */
    @JsonProperty("BuildRequest")
    public io.fabric8.openshift.api.model.BuildRequest getBuildRequest() {
        return BuildRequest;
    }

    /**
     * 
     * 
     * @param BuildRequest
     *     The BuildRequest
     */
    @JsonProperty("BuildRequest")
    public void setBuildRequest(io.fabric8.openshift.api.model.BuildRequest BuildRequest) {
        this.BuildRequest = BuildRequest;
    }

    /**
     * 
     * 
     * @return
     *     The ClusterPolicy
     */
    @JsonProperty("ClusterPolicy")
    public io.fabric8.openshift.api.model.ClusterPolicy getClusterPolicy() {
        return ClusterPolicy;
    }

    /**
     * 
     * 
     * @param ClusterPolicy
     *     The ClusterPolicy
     */
    @JsonProperty("ClusterPolicy")
    public void setClusterPolicy(io.fabric8.openshift.api.model.ClusterPolicy ClusterPolicy) {
        this.ClusterPolicy = ClusterPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The ClusterPolicyBinding
     */
    @JsonProperty("ClusterPolicyBinding")
    public io.fabric8.openshift.api.model.ClusterPolicyBinding getClusterPolicyBinding() {
        return ClusterPolicyBinding;
    }

    /**
     * 
     * 
     * @param ClusterPolicyBinding
     *     The ClusterPolicyBinding
     */
    @JsonProperty("ClusterPolicyBinding")
    public void setClusterPolicyBinding(io.fabric8.openshift.api.model.ClusterPolicyBinding ClusterPolicyBinding) {
        this.ClusterPolicyBinding = ClusterPolicyBinding;
    }

    /**
     * 
     * 
     * @return
     *     The ClusterPolicyBindingList
     */
    @JsonProperty("ClusterPolicyBindingList")
    public io.fabric8.openshift.api.model.ClusterPolicyBindingList getClusterPolicyBindingList() {
        return ClusterPolicyBindingList;
    }

    /**
     * 
     * 
     * @param ClusterPolicyBindingList
     *     The ClusterPolicyBindingList
     */
    @JsonProperty("ClusterPolicyBindingList")
    public void setClusterPolicyBindingList(io.fabric8.openshift.api.model.ClusterPolicyBindingList ClusterPolicyBindingList) {
        this.ClusterPolicyBindingList = ClusterPolicyBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The ClusterPolicyList
     */
    @JsonProperty("ClusterPolicyList")
    public io.fabric8.openshift.api.model.ClusterPolicyList getClusterPolicyList() {
        return ClusterPolicyList;
    }

    /**
     * 
     * 
     * @param ClusterPolicyList
     *     The ClusterPolicyList
     */
    @JsonProperty("ClusterPolicyList")
    public void setClusterPolicyList(io.fabric8.openshift.api.model.ClusterPolicyList ClusterPolicyList) {
        this.ClusterPolicyList = ClusterPolicyList;
    }

    /**
     * 
     * 
     * @return
     *     The ClusterRoleBinding
     */
    @JsonProperty("ClusterRoleBinding")
    public io.fabric8.openshift.api.model.ClusterRoleBinding getClusterRoleBinding() {
        return ClusterRoleBinding;
    }

    /**
     * 
     * 
     * @param ClusterRoleBinding
     *     The ClusterRoleBinding
     */
    @JsonProperty("ClusterRoleBinding")
    public void setClusterRoleBinding(io.fabric8.openshift.api.model.ClusterRoleBinding ClusterRoleBinding) {
        this.ClusterRoleBinding = ClusterRoleBinding;
    }

    /**
     * 
     * 
     * @return
     *     The ClusterRoleBindingList
     */
    @JsonProperty("ClusterRoleBindingList")
    public io.fabric8.openshift.api.model.ClusterRoleBindingList getClusterRoleBindingList() {
        return ClusterRoleBindingList;
    }

    /**
     * 
     * 
     * @param ClusterRoleBindingList
     *     The ClusterRoleBindingList
     */
    @JsonProperty("ClusterRoleBindingList")
    public void setClusterRoleBindingList(io.fabric8.openshift.api.model.ClusterRoleBindingList ClusterRoleBindingList) {
        this.ClusterRoleBindingList = ClusterRoleBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The ComponentStatusList
     */
    @JsonProperty("ComponentStatusList")
    public io.fabric8.kubernetes.api.model.ComponentStatusList getComponentStatusList() {
        return ComponentStatusList;
    }

    /**
     * 
     * 
     * @param ComponentStatusList
     *     The ComponentStatusList
     */
    @JsonProperty("ComponentStatusList")
    public void setComponentStatusList(io.fabric8.kubernetes.api.model.ComponentStatusList ComponentStatusList) {
        this.ComponentStatusList = ComponentStatusList;
    }

    /**
     * 
     * 
     * @return
     *     The Config
     */
    @JsonProperty("Config")
    public io.fabric8.kubernetes.api.model.Config getConfig() {
        return Config;
    }

    /**
     * 
     * 
     * @param Config
     *     The Config
     */
    @JsonProperty("Config")
    public void setConfig(io.fabric8.kubernetes.api.model.Config Config) {
        this.Config = Config;
    }

    /**
     * 
     * 
     * @return
     *     The ConfigMap
     */
    @JsonProperty("ConfigMap")
    public io.fabric8.kubernetes.api.model.extensions.ConfigMap getConfigMap() {
        return ConfigMap;
    }

    /**
     * 
     * 
     * @param ConfigMap
     *     The ConfigMap
     */
    @JsonProperty("ConfigMap")
    public void setConfigMap(io.fabric8.kubernetes.api.model.extensions.ConfigMap ConfigMap) {
        this.ConfigMap = ConfigMap;
    }

    /**
     * 
     * 
     * @return
     *     The ConfigMapList
     */
    @JsonProperty("ConfigMapList")
    public io.fabric8.kubernetes.api.model.extensions.ConfigMapList getConfigMapList() {
        return ConfigMapList;
    }

    /**
     * 
     * 
     * @param ConfigMapList
     *     The ConfigMapList
     */
    @JsonProperty("ConfigMapList")
    public void setConfigMapList(io.fabric8.kubernetes.api.model.extensions.ConfigMapList ConfigMapList) {
        this.ConfigMapList = ConfigMapList;
    }

    /**
     * 
     * 
     * @return
     *     The ContainerStatus
     */
    @JsonProperty("ContainerStatus")
    public io.fabric8.kubernetes.api.model.ContainerStatus getContainerStatus() {
        return ContainerStatus;
    }

    /**
     * 
     * 
     * @param ContainerStatus
     *     The ContainerStatus
     */
    @JsonProperty("ContainerStatus")
    public void setContainerStatus(io.fabric8.kubernetes.api.model.ContainerStatus ContainerStatus) {
        this.ContainerStatus = ContainerStatus;
    }

    /**
     * 
     * 
     * @return
     *     The DaemonSet
     */
    @JsonProperty("DaemonSet")
    public io.fabric8.kubernetes.api.model.extensions.DaemonSet getDaemonSet() {
        return DaemonSet;
    }

    /**
     * 
     * 
     * @param DaemonSet
     *     The DaemonSet
     */
    @JsonProperty("DaemonSet")
    public void setDaemonSet(io.fabric8.kubernetes.api.model.extensions.DaemonSet DaemonSet) {
        this.DaemonSet = DaemonSet;
    }

    /**
     * 
     * 
     * @return
     *     The DaemonSetList
     */
    @JsonProperty("DaemonSetList")
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetList getDaemonSetList() {
        return DaemonSetList;
    }

    /**
     * 
     * 
     * @param DaemonSetList
     *     The DaemonSetList
     */
    @JsonProperty("DaemonSetList")
    public void setDaemonSetList(io.fabric8.kubernetes.api.model.extensions.DaemonSetList DaemonSetList) {
        this.DaemonSetList = DaemonSetList;
    }

    /**
     * 
     * 
     * @return
     *     The DeleteOptions
     */
    @JsonProperty("DeleteOptions")
    public io.fabric8.kubernetes.api.model.DeleteOptions getDeleteOptions() {
        return DeleteOptions;
    }

    /**
     * 
     * 
     * @param DeleteOptions
     *     The DeleteOptions
     */
    @JsonProperty("DeleteOptions")
    public void setDeleteOptions(io.fabric8.kubernetes.api.model.DeleteOptions DeleteOptions) {
        this.DeleteOptions = DeleteOptions;
    }

    /**
     * 
     * 
     * @return
     *     The Deployment
     */
    @JsonProperty("Deployment")
    public io.fabric8.kubernetes.api.model.extensions.Deployment getDeployment() {
        return Deployment;
    }

    /**
     * 
     * 
     * @param Deployment
     *     The Deployment
     */
    @JsonProperty("Deployment")
    public void setDeployment(io.fabric8.kubernetes.api.model.extensions.Deployment Deployment) {
        this.Deployment = Deployment;
    }

    /**
     * 
     * 
     * @return
     *     The DeploymentConfigList
     */
    @JsonProperty("DeploymentConfigList")
    public io.fabric8.openshift.api.model.DeploymentConfigList getDeploymentConfigList() {
        return DeploymentConfigList;
    }

    /**
     * 
     * 
     * @param DeploymentConfigList
     *     The DeploymentConfigList
     */
    @JsonProperty("DeploymentConfigList")
    public void setDeploymentConfigList(io.fabric8.openshift.api.model.DeploymentConfigList DeploymentConfigList) {
        this.DeploymentConfigList = DeploymentConfigList;
    }

    /**
     * 
     * 
     * @return
     *     The DeploymentList
     */
    @JsonProperty("DeploymentList")
    public io.fabric8.kubernetes.api.model.extensions.DeploymentList getDeploymentList() {
        return DeploymentList;
    }

    /**
     * 
     * 
     * @param DeploymentList
     *     The DeploymentList
     */
    @JsonProperty("DeploymentList")
    public void setDeploymentList(io.fabric8.kubernetes.api.model.extensions.DeploymentList DeploymentList) {
        this.DeploymentList = DeploymentList;
    }

    /**
     * 
     * 
     * @return
     *     The Endpoints
     */
    @JsonProperty("Endpoints")
    public io.fabric8.kubernetes.api.model.Endpoints getEndpoints() {
        return Endpoints;
    }

    /**
     * 
     * 
     * @param Endpoints
     *     The Endpoints
     */
    @JsonProperty("Endpoints")
    public void setEndpoints(io.fabric8.kubernetes.api.model.Endpoints Endpoints) {
        this.Endpoints = Endpoints;
    }

    /**
     * 
     * 
     * @return
     *     The EndpointsList
     */
    @JsonProperty("EndpointsList")
    public io.fabric8.kubernetes.api.model.EndpointsList getEndpointsList() {
        return EndpointsList;
    }

    /**
     * 
     * 
     * @param EndpointsList
     *     The EndpointsList
     */
    @JsonProperty("EndpointsList")
    public void setEndpointsList(io.fabric8.kubernetes.api.model.EndpointsList EndpointsList) {
        this.EndpointsList = EndpointsList;
    }

    /**
     * 
     * 
     * @return
     *     The EnvVar
     */
    @JsonProperty("EnvVar")
    public io.fabric8.kubernetes.api.model.EnvVar getEnvVar() {
        return EnvVar;
    }

    /**
     * 
     * 
     * @param EnvVar
     *     The EnvVar
     */
    @JsonProperty("EnvVar")
    public void setEnvVar(io.fabric8.kubernetes.api.model.EnvVar EnvVar) {
        this.EnvVar = EnvVar;
    }

    /**
     * 
     * 
     * @return
     *     The EventList
     */
    @JsonProperty("EventList")
    public io.fabric8.kubernetes.api.model.EventList getEventList() {
        return EventList;
    }

    /**
     * 
     * 
     * @param EventList
     *     The EventList
     */
    @JsonProperty("EventList")
    public void setEventList(io.fabric8.kubernetes.api.model.EventList EventList) {
        this.EventList = EventList;
    }

    /**
     * 
     * 
     * @return
     *     The Group
     */
    @JsonProperty("Group")
    public io.fabric8.openshift.api.model.Group getGroup() {
        return Group;
    }

    /**
     * 
     * 
     * @param Group
     *     The Group
     */
    @JsonProperty("Group")
    public void setGroup(io.fabric8.openshift.api.model.Group Group) {
        this.Group = Group;
    }

    /**
     * 
     * 
     * @return
     *     The GroupList
     */
    @JsonProperty("GroupList")
    public io.fabric8.openshift.api.model.GroupList getGroupList() {
        return GroupList;
    }

    /**
     * 
     * 
     * @param GroupList
     *     The GroupList
     */
    @JsonProperty("GroupList")
    public void setGroupList(io.fabric8.openshift.api.model.GroupList GroupList) {
        this.GroupList = GroupList;
    }

    /**
     * 
     * 
     * @return
     *     The HorizontalPodAutoscaler
     */
    @JsonProperty("HorizontalPodAutoscaler")
    public io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler getHorizontalPodAutoscaler() {
        return HorizontalPodAutoscaler;
    }

    /**
     * 
     * 
     * @param HorizontalPodAutoscaler
     *     The HorizontalPodAutoscaler
     */
    @JsonProperty("HorizontalPodAutoscaler")
    public void setHorizontalPodAutoscaler(io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler HorizontalPodAutoscaler) {
        this.HorizontalPodAutoscaler = HorizontalPodAutoscaler;
    }

    /**
     * 
     * 
     * @return
     *     The HorizontalPodAutoscalerList
     */
    @JsonProperty("HorizontalPodAutoscalerList")
    public io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList getHorizontalPodAutoscalerList() {
        return HorizontalPodAutoscalerList;
    }

    /**
     * 
     * 
     * @param HorizontalPodAutoscalerList
     *     The HorizontalPodAutoscalerList
     */
    @JsonProperty("HorizontalPodAutoscalerList")
    public void setHorizontalPodAutoscalerList(io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList HorizontalPodAutoscalerList) {
        this.HorizontalPodAutoscalerList = HorizontalPodAutoscalerList;
    }

    /**
     * 
     * 
     * @return
     *     The Identity
     */
    @JsonProperty("Identity")
    public io.fabric8.openshift.api.model.Identity getIdentity() {
        return Identity;
    }

    /**
     * 
     * 
     * @param Identity
     *     The Identity
     */
    @JsonProperty("Identity")
    public void setIdentity(io.fabric8.openshift.api.model.Identity Identity) {
        this.Identity = Identity;
    }

    /**
     * 
     * 
     * @return
     *     The IdentityList
     */
    @JsonProperty("IdentityList")
    public io.fabric8.openshift.api.model.IdentityList getIdentityList() {
        return IdentityList;
    }

    /**
     * 
     * 
     * @param IdentityList
     *     The IdentityList
     */
    @JsonProperty("IdentityList")
    public void setIdentityList(io.fabric8.openshift.api.model.IdentityList IdentityList) {
        this.IdentityList = IdentityList;
    }

    /**
     * 
     * 
     * @return
     *     The ImageList
     */
    @JsonProperty("ImageList")
    public io.fabric8.openshift.api.model.ImageList getImageList() {
        return ImageList;
    }

    /**
     * 
     * 
     * @param ImageList
     *     The ImageList
     */
    @JsonProperty("ImageList")
    public void setImageList(io.fabric8.openshift.api.model.ImageList ImageList) {
        this.ImageList = ImageList;
    }

    /**
     * 
     * 
     * @return
     *     The ImageStreamList
     */
    @JsonProperty("ImageStreamList")
    public io.fabric8.openshift.api.model.ImageStreamList getImageStreamList() {
        return ImageStreamList;
    }

    /**
     * 
     * 
     * @param ImageStreamList
     *     The ImageStreamList
     */
    @JsonProperty("ImageStreamList")
    public void setImageStreamList(io.fabric8.openshift.api.model.ImageStreamList ImageStreamList) {
        this.ImageStreamList = ImageStreamList;
    }

    /**
     * 
     * 
     * @return
     *     The Ingress
     */
    @JsonProperty("Ingress")
    public io.fabric8.kubernetes.api.model.extensions.Ingress getIngress() {
        return Ingress;
    }

    /**
     * 
     * 
     * @param Ingress
     *     The Ingress
     */
    @JsonProperty("Ingress")
    public void setIngress(io.fabric8.kubernetes.api.model.extensions.Ingress Ingress) {
        this.Ingress = Ingress;
    }

    /**
     * 
     * 
     * @return
     *     The IngressList
     */
    @JsonProperty("IngressList")
    public io.fabric8.kubernetes.api.model.extensions.IngressList getIngressList() {
        return IngressList;
    }

    /**
     * 
     * 
     * @param IngressList
     *     The IngressList
     */
    @JsonProperty("IngressList")
    public void setIngressList(io.fabric8.kubernetes.api.model.extensions.IngressList IngressList) {
        this.IngressList = IngressList;
    }

    /**
     * 
     * 
     * @return
     *     The Job
     */
    @JsonProperty("Job")
    public io.fabric8.kubernetes.api.model.extensions.Job getJob() {
        return Job;
    }

    /**
     * 
     * 
     * @param Job
     *     The Job
     */
    @JsonProperty("Job")
    public void setJob(io.fabric8.kubernetes.api.model.extensions.Job Job) {
        this.Job = Job;
    }

    /**
     * 
     * 
     * @return
     *     The JobList
     */
    @JsonProperty("JobList")
    public io.fabric8.kubernetes.api.model.extensions.JobList getJobList() {
        return JobList;
    }

    /**
     * 
     * 
     * @param JobList
     *     The JobList
     */
    @JsonProperty("JobList")
    public void setJobList(io.fabric8.kubernetes.api.model.extensions.JobList JobList) {
        this.JobList = JobList;
    }

    /**
     * 
     * 
     * @return
     *     The LimitRangeList
     */
    @JsonProperty("LimitRangeList")
    public io.fabric8.kubernetes.api.model.LimitRangeList getLimitRangeList() {
        return LimitRangeList;
    }

    /**
     * 
     * 
     * @param LimitRangeList
     *     The LimitRangeList
     */
    @JsonProperty("LimitRangeList")
    public void setLimitRangeList(io.fabric8.kubernetes.api.model.LimitRangeList LimitRangeList) {
        this.LimitRangeList = LimitRangeList;
    }

    /**
     * 
     * 
     * @return
     *     The ListMeta
     */
    @JsonProperty("ListMeta")
    public io.fabric8.kubernetes.api.model.ListMeta getListMeta() {
        return ListMeta;
    }

    /**
     * 
     * 
     * @param ListMeta
     *     The ListMeta
     */
    @JsonProperty("ListMeta")
    public void setListMeta(io.fabric8.kubernetes.api.model.ListMeta ListMeta) {
        this.ListMeta = ListMeta;
    }

    /**
     * 
     * 
     * @return
     *     The LocalSubjectAccessReview
     */
    @JsonProperty("LocalSubjectAccessReview")
    public io.fabric8.openshift.api.model.LocalSubjectAccessReview getLocalSubjectAccessReview() {
        return LocalSubjectAccessReview;
    }

    /**
     * 
     * 
     * @param LocalSubjectAccessReview
     *     The LocalSubjectAccessReview
     */
    @JsonProperty("LocalSubjectAccessReview")
    public void setLocalSubjectAccessReview(io.fabric8.openshift.api.model.LocalSubjectAccessReview LocalSubjectAccessReview) {
        this.LocalSubjectAccessReview = LocalSubjectAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The Namespace
     */
    @JsonProperty("Namespace")
    public io.fabric8.kubernetes.api.model.Namespace getNamespace() {
        return Namespace;
    }

    /**
     * 
     * 
     * @param Namespace
     *     The Namespace
     */
    @JsonProperty("Namespace")
    public void setNamespace(io.fabric8.kubernetes.api.model.Namespace Namespace) {
        this.Namespace = Namespace;
    }

    /**
     * 
     * 
     * @return
     *     The NamespaceList
     */
    @JsonProperty("NamespaceList")
    public io.fabric8.kubernetes.api.model.NamespaceList getNamespaceList() {
        return NamespaceList;
    }

    /**
     * 
     * 
     * @param NamespaceList
     *     The NamespaceList
     */
    @JsonProperty("NamespaceList")
    public void setNamespaceList(io.fabric8.kubernetes.api.model.NamespaceList NamespaceList) {
        this.NamespaceList = NamespaceList;
    }

    /**
     * 
     * 
     * @return
     *     The Node
     */
    @JsonProperty("Node")
    public io.fabric8.kubernetes.api.model.Node getNode() {
        return Node;
    }

    /**
     * 
     * 
     * @param Node
     *     The Node
     */
    @JsonProperty("Node")
    public void setNode(io.fabric8.kubernetes.api.model.Node Node) {
        this.Node = Node;
    }

    /**
     * 
     * 
     * @return
     *     The NodeList
     */
    @JsonProperty("NodeList")
    public io.fabric8.kubernetes.api.model.NodeList getNodeList() {
        return NodeList;
    }

    /**
     * 
     * 
     * @param NodeList
     *     The NodeList
     */
    @JsonProperty("NodeList")
    public void setNodeList(io.fabric8.kubernetes.api.model.NodeList NodeList) {
        this.NodeList = NodeList;
    }

    /**
     * 
     * 
     * @return
     *     The OAuthAccessToken
     */
    @JsonProperty("OAuthAccessToken")
    public io.fabric8.openshift.api.model.OAuthAccessToken getOAuthAccessToken() {
        return OAuthAccessToken;
    }

    /**
     * 
     * 
     * @param OAuthAccessToken
     *     The OAuthAccessToken
     */
    @JsonProperty("OAuthAccessToken")
    public void setOAuthAccessToken(io.fabric8.openshift.api.model.OAuthAccessToken OAuthAccessToken) {
        this.OAuthAccessToken = OAuthAccessToken;
    }

    /**
     * 
     * 
     * @return
     *     The OAuthAccessTokenList
     */
    @JsonProperty("OAuthAccessTokenList")
    public io.fabric8.openshift.api.model.OAuthAccessTokenList getOAuthAccessTokenList() {
        return OAuthAccessTokenList;
    }

    /**
     * 
     * 
     * @param OAuthAccessTokenList
     *     The OAuthAccessTokenList
     */
    @JsonProperty("OAuthAccessTokenList")
    public void setOAuthAccessTokenList(io.fabric8.openshift.api.model.OAuthAccessTokenList OAuthAccessTokenList) {
        this.OAuthAccessTokenList = OAuthAccessTokenList;
    }

    /**
     * 
     * 
     * @return
     *     The OAuthAuthorizeToken
     */
    @JsonProperty("OAuthAuthorizeToken")
    public io.fabric8.openshift.api.model.OAuthAuthorizeToken getOAuthAuthorizeToken() {
        return OAuthAuthorizeToken;
    }

    /**
     * 
     * 
     * @param OAuthAuthorizeToken
     *     The OAuthAuthorizeToken
     */
    @JsonProperty("OAuthAuthorizeToken")
    public void setOAuthAuthorizeToken(io.fabric8.openshift.api.model.OAuthAuthorizeToken OAuthAuthorizeToken) {
        this.OAuthAuthorizeToken = OAuthAuthorizeToken;
    }

    /**
     * 
     * 
     * @return
     *     The OAuthAuthorizeTokenList
     */
    @JsonProperty("OAuthAuthorizeTokenList")
    public io.fabric8.openshift.api.model.OAuthAuthorizeTokenList getOAuthAuthorizeTokenList() {
        return OAuthAuthorizeTokenList;
    }

    /**
     * 
     * 
     * @param OAuthAuthorizeTokenList
     *     The OAuthAuthorizeTokenList
     */
    @JsonProperty("OAuthAuthorizeTokenList")
    public void setOAuthAuthorizeTokenList(io.fabric8.openshift.api.model.OAuthAuthorizeTokenList OAuthAuthorizeTokenList) {
        this.OAuthAuthorizeTokenList = OAuthAuthorizeTokenList;
    }

    /**
     * 
     * 
     * @return
     *     The OAuthClient
     */
    @JsonProperty("OAuthClient")
    public io.fabric8.openshift.api.model.OAuthClient getOAuthClient() {
        return OAuthClient;
    }

    /**
     * 
     * 
     * @param OAuthClient
     *     The OAuthClient
     */
    @JsonProperty("OAuthClient")
    public void setOAuthClient(io.fabric8.openshift.api.model.OAuthClient OAuthClient) {
        this.OAuthClient = OAuthClient;
    }

    /**
     * 
     * 
     * @return
     *     The OAuthClientAuthorization
     */
    @JsonProperty("OAuthClientAuthorization")
    public io.fabric8.openshift.api.model.OAuthClientAuthorization getOAuthClientAuthorization() {
        return OAuthClientAuthorization;
    }

    /**
     * 
     * 
     * @param OAuthClientAuthorization
     *     The OAuthClientAuthorization
     */
    @JsonProperty("OAuthClientAuthorization")
    public void setOAuthClientAuthorization(io.fabric8.openshift.api.model.OAuthClientAuthorization OAuthClientAuthorization) {
        this.OAuthClientAuthorization = OAuthClientAuthorization;
    }

    /**
     * 
     * 
     * @return
     *     The OAuthClientAuthorizationList
     */
    @JsonProperty("OAuthClientAuthorizationList")
    public io.fabric8.openshift.api.model.OAuthClientAuthorizationList getOAuthClientAuthorizationList() {
        return OAuthClientAuthorizationList;
    }

    /**
     * 
     * 
     * @param OAuthClientAuthorizationList
     *     The OAuthClientAuthorizationList
     */
    @JsonProperty("OAuthClientAuthorizationList")
    public void setOAuthClientAuthorizationList(io.fabric8.openshift.api.model.OAuthClientAuthorizationList OAuthClientAuthorizationList) {
        this.OAuthClientAuthorizationList = OAuthClientAuthorizationList;
    }

    /**
     * 
     * 
     * @return
     *     The OAuthClientList
     */
    @JsonProperty("OAuthClientList")
    public io.fabric8.openshift.api.model.OAuthClientList getOAuthClientList() {
        return OAuthClientList;
    }

    /**
     * 
     * 
     * @param OAuthClientList
     *     The OAuthClientList
     */
    @JsonProperty("OAuthClientList")
    public void setOAuthClientList(io.fabric8.openshift.api.model.OAuthClientList OAuthClientList) {
        this.OAuthClientList = OAuthClientList;
    }

    /**
     * 
     * 
     * @return
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return ObjectMeta;
    }

    /**
     * 
     * 
     * @param ObjectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta ObjectMeta) {
        this.ObjectMeta = ObjectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The PersistentVolume
     */
    @JsonProperty("PersistentVolume")
    public io.fabric8.kubernetes.api.model.PersistentVolume getPersistentVolume() {
        return PersistentVolume;
    }

    /**
     * 
     * 
     * @param PersistentVolume
     *     The PersistentVolume
     */
    @JsonProperty("PersistentVolume")
    public void setPersistentVolume(io.fabric8.kubernetes.api.model.PersistentVolume PersistentVolume) {
        this.PersistentVolume = PersistentVolume;
    }

    /**
     * 
     * 
     * @return
     *     The PersistentVolumeClaim
     */
    @JsonProperty("PersistentVolumeClaim")
    public io.fabric8.kubernetes.api.model.PersistentVolumeClaim getPersistentVolumeClaim() {
        return PersistentVolumeClaim;
    }

    /**
     * 
     * 
     * @param PersistentVolumeClaim
     *     The PersistentVolumeClaim
     */
    @JsonProperty("PersistentVolumeClaim")
    public void setPersistentVolumeClaim(io.fabric8.kubernetes.api.model.PersistentVolumeClaim PersistentVolumeClaim) {
        this.PersistentVolumeClaim = PersistentVolumeClaim;
    }

    /**
     * 
     * 
     * @return
     *     The PersistentVolumeClaimList
     */
    @JsonProperty("PersistentVolumeClaimList")
    public io.fabric8.kubernetes.api.model.PersistentVolumeClaimList getPersistentVolumeClaimList() {
        return PersistentVolumeClaimList;
    }

    /**
     * 
     * 
     * @param PersistentVolumeClaimList
     *     The PersistentVolumeClaimList
     */
    @JsonProperty("PersistentVolumeClaimList")
    public void setPersistentVolumeClaimList(io.fabric8.kubernetes.api.model.PersistentVolumeClaimList PersistentVolumeClaimList) {
        this.PersistentVolumeClaimList = PersistentVolumeClaimList;
    }

    /**
     * 
     * 
     * @return
     *     The PersistentVolumeList
     */
    @JsonProperty("PersistentVolumeList")
    public io.fabric8.kubernetes.api.model.PersistentVolumeList getPersistentVolumeList() {
        return PersistentVolumeList;
    }

    /**
     * 
     * 
     * @param PersistentVolumeList
     *     The PersistentVolumeList
     */
    @JsonProperty("PersistentVolumeList")
    public void setPersistentVolumeList(io.fabric8.kubernetes.api.model.PersistentVolumeList PersistentVolumeList) {
        this.PersistentVolumeList = PersistentVolumeList;
    }

    /**
     * 
     * 
     * @return
     *     The PodList
     */
    @JsonProperty("PodList")
    public io.fabric8.kubernetes.api.model.PodList getPodList() {
        return PodList;
    }

    /**
     * 
     * 
     * @param PodList
     *     The PodList
     */
    @JsonProperty("PodList")
    public void setPodList(io.fabric8.kubernetes.api.model.PodList PodList) {
        this.PodList = PodList;
    }

    /**
     * 
     * 
     * @return
     *     The PodTemplateList
     */
    @JsonProperty("PodTemplateList")
    public io.fabric8.kubernetes.api.model.PodTemplateList getPodTemplateList() {
        return PodTemplateList;
    }

    /**
     * 
     * 
     * @param PodTemplateList
     *     The PodTemplateList
     */
    @JsonProperty("PodTemplateList")
    public void setPodTemplateList(io.fabric8.kubernetes.api.model.PodTemplateList PodTemplateList) {
        this.PodTemplateList = PodTemplateList;
    }

    /**
     * 
     * 
     * @return
     *     The Policy
     */
    @JsonProperty("Policy")
    public io.fabric8.openshift.api.model.Policy getPolicy() {
        return Policy;
    }

    /**
     * 
     * 
     * @param Policy
     *     The Policy
     */
    @JsonProperty("Policy")
    public void setPolicy(io.fabric8.openshift.api.model.Policy Policy) {
        this.Policy = Policy;
    }

    /**
     * 
     * 
     * @return
     *     The PolicyBinding
     */
    @JsonProperty("PolicyBinding")
    public io.fabric8.openshift.api.model.PolicyBinding getPolicyBinding() {
        return PolicyBinding;
    }

    /**
     * 
     * 
     * @param PolicyBinding
     *     The PolicyBinding
     */
    @JsonProperty("PolicyBinding")
    public void setPolicyBinding(io.fabric8.openshift.api.model.PolicyBinding PolicyBinding) {
        this.PolicyBinding = PolicyBinding;
    }

    /**
     * 
     * 
     * @return
     *     The PolicyBindingList
     */
    @JsonProperty("PolicyBindingList")
    public io.fabric8.openshift.api.model.PolicyBindingList getPolicyBindingList() {
        return PolicyBindingList;
    }

    /**
     * 
     * 
     * @param PolicyBindingList
     *     The PolicyBindingList
     */
    @JsonProperty("PolicyBindingList")
    public void setPolicyBindingList(io.fabric8.openshift.api.model.PolicyBindingList PolicyBindingList) {
        this.PolicyBindingList = PolicyBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The PolicyList
     */
    @JsonProperty("PolicyList")
    public io.fabric8.openshift.api.model.PolicyList getPolicyList() {
        return PolicyList;
    }

    /**
     * 
     * 
     * @param PolicyList
     *     The PolicyList
     */
    @JsonProperty("PolicyList")
    public void setPolicyList(io.fabric8.openshift.api.model.PolicyList PolicyList) {
        this.PolicyList = PolicyList;
    }

    /**
     * 
     * 
     * @return
     *     The Project
     */
    @JsonProperty("Project")
    public io.fabric8.openshift.api.model.Project getProject() {
        return Project;
    }

    /**
     * 
     * 
     * @param Project
     *     The Project
     */
    @JsonProperty("Project")
    public void setProject(io.fabric8.openshift.api.model.Project Project) {
        this.Project = Project;
    }

    /**
     * 
     * 
     * @return
     *     The ProjectList
     */
    @JsonProperty("ProjectList")
    public io.fabric8.openshift.api.model.ProjectList getProjectList() {
        return ProjectList;
    }

    /**
     * 
     * 
     * @param ProjectList
     *     The ProjectList
     */
    @JsonProperty("ProjectList")
    public void setProjectList(io.fabric8.openshift.api.model.ProjectList ProjectList) {
        this.ProjectList = ProjectList;
    }

    /**
     * 
     * 
     * @return
     *     The ProjectRequest
     */
    @JsonProperty("ProjectRequest")
    public io.fabric8.openshift.api.model.ProjectRequest getProjectRequest() {
        return ProjectRequest;
    }

    /**
     * 
     * 
     * @param ProjectRequest
     *     The ProjectRequest
     */
    @JsonProperty("ProjectRequest")
    public void setProjectRequest(io.fabric8.openshift.api.model.ProjectRequest ProjectRequest) {
        this.ProjectRequest = ProjectRequest;
    }

    /**
     * 
     * 
     * @return
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public io.fabric8.kubernetes.api.model.Quantity getQuantity() {
        return Quantity;
    }

    /**
     * 
     * 
     * @param Quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(io.fabric8.kubernetes.api.model.Quantity Quantity) {
        this.Quantity = Quantity;
    }

    /**
     * 
     * 
     * @return
     *     The ReplicationControllerList
     */
    @JsonProperty("ReplicationControllerList")
    public io.fabric8.kubernetes.api.model.ReplicationControllerList getReplicationControllerList() {
        return ReplicationControllerList;
    }

    /**
     * 
     * 
     * @param ReplicationControllerList
     *     The ReplicationControllerList
     */
    @JsonProperty("ReplicationControllerList")
    public void setReplicationControllerList(io.fabric8.kubernetes.api.model.ReplicationControllerList ReplicationControllerList) {
        this.ReplicationControllerList = ReplicationControllerList;
    }

    /**
     * 
     * 
     * @return
     *     The ResourceQuota
     */
    @JsonProperty("ResourceQuota")
    public io.fabric8.kubernetes.api.model.ResourceQuota getResourceQuota() {
        return ResourceQuota;
    }

    /**
     * 
     * 
     * @param ResourceQuota
     *     The ResourceQuota
     */
    @JsonProperty("ResourceQuota")
    public void setResourceQuota(io.fabric8.kubernetes.api.model.ResourceQuota ResourceQuota) {
        this.ResourceQuota = ResourceQuota;
    }

    /**
     * 
     * 
     * @return
     *     The ResourceQuotaList
     */
    @JsonProperty("ResourceQuotaList")
    public io.fabric8.kubernetes.api.model.ResourceQuotaList getResourceQuotaList() {
        return ResourceQuotaList;
    }

    /**
     * 
     * 
     * @param ResourceQuotaList
     *     The ResourceQuotaList
     */
    @JsonProperty("ResourceQuotaList")
    public void setResourceQuotaList(io.fabric8.kubernetes.api.model.ResourceQuotaList ResourceQuotaList) {
        this.ResourceQuotaList = ResourceQuotaList;
    }

    /**
     * 
     * 
     * @return
     *     The Role
     */
    @JsonProperty("Role")
    public io.fabric8.openshift.api.model.Role getRole() {
        return Role;
    }

    /**
     * 
     * 
     * @param Role
     *     The Role
     */
    @JsonProperty("Role")
    public void setRole(io.fabric8.openshift.api.model.Role Role) {
        this.Role = Role;
    }

    /**
     * 
     * 
     * @return
     *     The RoleBinding
     */
    @JsonProperty("RoleBinding")
    public io.fabric8.openshift.api.model.RoleBinding getRoleBinding() {
        return RoleBinding;
    }

    /**
     * 
     * 
     * @param RoleBinding
     *     The RoleBinding
     */
    @JsonProperty("RoleBinding")
    public void setRoleBinding(io.fabric8.openshift.api.model.RoleBinding RoleBinding) {
        this.RoleBinding = RoleBinding;
    }

    /**
     * 
     * 
     * @return
     *     The RoleBindingList
     */
    @JsonProperty("RoleBindingList")
    public io.fabric8.openshift.api.model.RoleBindingList getRoleBindingList() {
        return RoleBindingList;
    }

    /**
     * 
     * 
     * @param RoleBindingList
     *     The RoleBindingList
     */
    @JsonProperty("RoleBindingList")
    public void setRoleBindingList(io.fabric8.openshift.api.model.RoleBindingList RoleBindingList) {
        this.RoleBindingList = RoleBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The RoleList
     */
    @JsonProperty("RoleList")
    public io.fabric8.openshift.api.model.RoleList getRoleList() {
        return RoleList;
    }

    /**
     * 
     * 
     * @param RoleList
     *     The RoleList
     */
    @JsonProperty("RoleList")
    public void setRoleList(io.fabric8.openshift.api.model.RoleList RoleList) {
        this.RoleList = RoleList;
    }

    /**
     * 
     * 
     * @return
     *     The RootPaths
     */
    @JsonProperty("RootPaths")
    public io.fabric8.kubernetes.api.model.RootPaths getRootPaths() {
        return RootPaths;
    }

    /**
     * 
     * 
     * @param RootPaths
     *     The RootPaths
     */
    @JsonProperty("RootPaths")
    public void setRootPaths(io.fabric8.kubernetes.api.model.RootPaths RootPaths) {
        this.RootPaths = RootPaths;
    }

    /**
     * 
     * 
     * @return
     *     The RouteList
     */
    @JsonProperty("RouteList")
    public io.fabric8.openshift.api.model.RouteList getRouteList() {
        return RouteList;
    }

    /**
     * 
     * 
     * @param RouteList
     *     The RouteList
     */
    @JsonProperty("RouteList")
    public void setRouteList(io.fabric8.openshift.api.model.RouteList RouteList) {
        this.RouteList = RouteList;
    }

    /**
     * 
     * 
     * @return
     *     The Scale
     */
    @JsonProperty("Scale")
    public io.fabric8.kubernetes.api.model.extensions.Scale getScale() {
        return Scale;
    }

    /**
     * 
     * 
     * @param Scale
     *     The Scale
     */
    @JsonProperty("Scale")
    public void setScale(io.fabric8.kubernetes.api.model.extensions.Scale Scale) {
        this.Scale = Scale;
    }

    /**
     * 
     * 
     * @return
     *     The Secret
     */
    @JsonProperty("Secret")
    public io.fabric8.kubernetes.api.model.Secret getSecret() {
        return Secret;
    }

    /**
     * 
     * 
     * @param Secret
     *     The Secret
     */
    @JsonProperty("Secret")
    public void setSecret(io.fabric8.kubernetes.api.model.Secret Secret) {
        this.Secret = Secret;
    }

    /**
     * 
     * 
     * @return
     *     The SecretList
     */
    @JsonProperty("SecretList")
    public io.fabric8.kubernetes.api.model.SecretList getSecretList() {
        return SecretList;
    }

    /**
     * 
     * 
     * @param SecretList
     *     The SecretList
     */
    @JsonProperty("SecretList")
    public void setSecretList(io.fabric8.kubernetes.api.model.SecretList SecretList) {
        this.SecretList = SecretList;
    }

    /**
     * 
     * 
     * @return
     *     The SecurityContextConstraints
     */
    @JsonProperty("SecurityContextConstraints")
    public io.fabric8.kubernetes.api.model.SecurityContextConstraints getSecurityContextConstraints() {
        return SecurityContextConstraints;
    }

    /**
     * 
     * 
     * @param SecurityContextConstraints
     *     The SecurityContextConstraints
     */
    @JsonProperty("SecurityContextConstraints")
    public void setSecurityContextConstraints(io.fabric8.kubernetes.api.model.SecurityContextConstraints SecurityContextConstraints) {
        this.SecurityContextConstraints = SecurityContextConstraints;
    }

    /**
     * 
     * 
     * @return
     *     The SecurityContextConstraintsList
     */
    @JsonProperty("SecurityContextConstraintsList")
    public io.fabric8.kubernetes.api.model.SecurityContextConstraintsList getSecurityContextConstraintsList() {
        return SecurityContextConstraintsList;
    }

    /**
     * 
     * 
     * @param SecurityContextConstraintsList
     *     The SecurityContextConstraintsList
     */
    @JsonProperty("SecurityContextConstraintsList")
    public void setSecurityContextConstraintsList(io.fabric8.kubernetes.api.model.SecurityContextConstraintsList SecurityContextConstraintsList) {
        this.SecurityContextConstraintsList = SecurityContextConstraintsList;
    }

    /**
     * 
     * 
     * @return
     *     The ServiceAccount
     */
    @JsonProperty("ServiceAccount")
    public io.fabric8.kubernetes.api.model.ServiceAccount getServiceAccount() {
        return ServiceAccount;
    }

    /**
     * 
     * 
     * @param ServiceAccount
     *     The ServiceAccount
     */
    @JsonProperty("ServiceAccount")
    public void setServiceAccount(io.fabric8.kubernetes.api.model.ServiceAccount ServiceAccount) {
        this.ServiceAccount = ServiceAccount;
    }

    /**
     * 
     * 
     * @return
     *     The ServiceAccountList
     */
    @JsonProperty("ServiceAccountList")
    public io.fabric8.kubernetes.api.model.ServiceAccountList getServiceAccountList() {
        return ServiceAccountList;
    }

    /**
     * 
     * 
     * @param ServiceAccountList
     *     The ServiceAccountList
     */
    @JsonProperty("ServiceAccountList")
    public void setServiceAccountList(io.fabric8.kubernetes.api.model.ServiceAccountList ServiceAccountList) {
        this.ServiceAccountList = ServiceAccountList;
    }

    /**
     * 
     * 
     * @return
     *     The ServiceList
     */
    @JsonProperty("ServiceList")
    public io.fabric8.kubernetes.api.model.ServiceList getServiceList() {
        return ServiceList;
    }

    /**
     * 
     * 
     * @param ServiceList
     *     The ServiceList
     */
    @JsonProperty("ServiceList")
    public void setServiceList(io.fabric8.kubernetes.api.model.ServiceList ServiceList) {
        this.ServiceList = ServiceList;
    }

    /**
     * 
     * 
     * @return
     *     The Status
     */
    @JsonProperty("Status")
    public io.fabric8.kubernetes.api.model.Status getStatus() {
        return Status;
    }

    /**
     * 
     * 
     * @param Status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(io.fabric8.kubernetes.api.model.Status Status) {
        this.Status = Status;
    }

    /**
     * 
     * 
     * @return
     *     The SubjectAccessReview
     */
    @JsonProperty("SubjectAccessReview")
    public io.fabric8.openshift.api.model.SubjectAccessReview getSubjectAccessReview() {
        return SubjectAccessReview;
    }

    /**
     * 
     * 
     * @param SubjectAccessReview
     *     The SubjectAccessReview
     */
    @JsonProperty("SubjectAccessReview")
    public void setSubjectAccessReview(io.fabric8.openshift.api.model.SubjectAccessReview SubjectAccessReview) {
        this.SubjectAccessReview = SubjectAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The SubjectAccessReviewResponse
     */
    @JsonProperty("SubjectAccessReviewResponse")
    public io.fabric8.openshift.api.model.SubjectAccessReviewResponse getSubjectAccessReviewResponse() {
        return SubjectAccessReviewResponse;
    }

    /**
     * 
     * 
     * @param SubjectAccessReviewResponse
     *     The SubjectAccessReviewResponse
     */
    @JsonProperty("SubjectAccessReviewResponse")
    public void setSubjectAccessReviewResponse(io.fabric8.openshift.api.model.SubjectAccessReviewResponse SubjectAccessReviewResponse) {
        this.SubjectAccessReviewResponse = SubjectAccessReviewResponse;
    }

    /**
     * 
     * 
     * @return
     *     The TagEvent
     */
    @JsonProperty("TagEvent")
    public io.fabric8.openshift.api.model.TagEvent getTagEvent() {
        return TagEvent;
    }

    /**
     * 
     * 
     * @param TagEvent
     *     The TagEvent
     */
    @JsonProperty("TagEvent")
    public void setTagEvent(io.fabric8.openshift.api.model.TagEvent TagEvent) {
        this.TagEvent = TagEvent;
    }

    /**
     * 
     * 
     * @return
     *     The Template
     */
    @JsonProperty("Template")
    public io.fabric8.openshift.api.model.Template getTemplate() {
        return Template;
    }

    /**
     * 
     * 
     * @param Template
     *     The Template
     */
    @JsonProperty("Template")
    public void setTemplate(io.fabric8.openshift.api.model.Template Template) {
        this.Template = Template;
    }

    /**
     * 
     * 
     * @return
     *     The TemplateList
     */
    @JsonProperty("TemplateList")
    public io.fabric8.openshift.api.model.TemplateList getTemplateList() {
        return TemplateList;
    }

    /**
     * 
     * 
     * @param TemplateList
     *     The TemplateList
     */
    @JsonProperty("TemplateList")
    public void setTemplateList(io.fabric8.openshift.api.model.TemplateList TemplateList) {
        this.TemplateList = TemplateList;
    }

    /**
     * 
     * 
     * @return
     *     The ThirdPartyResource
     */
    @JsonProperty("ThirdPartyResource")
    public io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource getThirdPartyResource() {
        return ThirdPartyResource;
    }

    /**
     * 
     * 
     * @param ThirdPartyResource
     *     The ThirdPartyResource
     */
    @JsonProperty("ThirdPartyResource")
    public void setThirdPartyResource(io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource ThirdPartyResource) {
        this.ThirdPartyResource = ThirdPartyResource;
    }

    /**
     * 
     * 
     * @return
     *     The ThirdPartyResourceList
     */
    @JsonProperty("ThirdPartyResourceList")
    public io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList getThirdPartyResourceList() {
        return ThirdPartyResourceList;
    }

    /**
     * 
     * 
     * @param ThirdPartyResourceList
     *     The ThirdPartyResourceList
     */
    @JsonProperty("ThirdPartyResourceList")
    public void setThirdPartyResourceList(io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList ThirdPartyResourceList) {
        this.ThirdPartyResourceList = ThirdPartyResourceList;
    }

    /**
     * 
     * 
     * @return
     *     The User
     */
    @JsonProperty("User")
    public io.fabric8.openshift.api.model.User getUser() {
        return User;
    }

    /**
     * 
     * 
     * @param User
     *     The User
     */
    @JsonProperty("User")
    public void setUser(io.fabric8.openshift.api.model.User User) {
        this.User = User;
    }

    /**
     * 
     * 
     * @return
     *     The UserList
     */
    @JsonProperty("UserList")
    public io.fabric8.openshift.api.model.UserList getUserList() {
        return UserList;
    }

    /**
     * 
     * 
     * @param UserList
     *     The UserList
     */
    @JsonProperty("UserList")
    public void setUserList(io.fabric8.openshift.api.model.UserList UserList) {
        this.UserList = UserList;
    }

    /**
     * 
     * 
     * @return
     *     The WatchEvent
     */
    @JsonProperty("WatchEvent")
    public io.fabric8.kubernetes.api.model.WatchEvent getWatchEvent() {
        return WatchEvent;
    }

    /**
     * 
     * 
     * @param WatchEvent
     *     The WatchEvent
     */
    @JsonProperty("WatchEvent")
    public void setWatchEvent(io.fabric8.kubernetes.api.model.WatchEvent WatchEvent) {
        this.WatchEvent = WatchEvent;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
