package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface NodeSystemInfoFluent<T extends NodeSystemInfoFluent<T>> extends Fluent<T>{


    public String getBootID();    public T withBootID( String bootID);    public String getContainerRuntimeVersion();    public T withContainerRuntimeVersion( String containerRuntimeVersion);    public String getKernelVersion();    public T withKernelVersion( String kernelVersion);    public String getKubeProxyVersion();    public T withKubeProxyVersion( String kubeProxyVersion);    public String getKubeletVersion();    public T withKubeletVersion( String kubeletVersion);    public String getMachineID();    public T withMachineID( String machineID);    public String getOsImage();    public T withOsImage( String osImage);    public String getSystemUUID();    public T withSystemUUID( String systemUUID);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);

}
