package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class SELinuxOptionsFluentImpl<T extends SELinuxOptionsFluent<T>> extends BaseFluent<T> implements SELinuxOptionsFluent<T>{

     String level;     String role;     String type;     String user;     Map<String, Object> additionalProperties = new HashMap();
public SELinuxOptionsFluentImpl(){
    
}
public SELinuxOptionsFluentImpl( SELinuxOptions instance ){
    this.withLevel(instance.getLevel()); this.withRole(instance.getRole()); this.withType(instance.getType()); this.withUser(instance.getUser()); 
}

    public String getLevel(){
    return this.level;
    }
    public T withLevel( String level){
    this.level=level; return (T) this;
    }
    public String getRole(){
    return this.role;
    }
    public T withRole( String role){
    this.role=role; return (T) this;
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public String getUser(){
    return this.user;
    }
    public T withUser( String user){
    this.user=user; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SELinuxOptionsFluentImpl that = (SELinuxOptionsFluentImpl) o;
if (level != null ? !level.equals(that.level) :that.level != null) return false;
if (role != null ? !role.equals(that.role) :that.role != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
