package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SecurityContextFluent<T extends SecurityContextFluent<T>> extends Fluent<T>{


    public Capabilities getCapabilities();    public T withCapabilities( Capabilities capabilities);    public CapabilitiesNested<T> withNewCapabilities();    public CapabilitiesNested<T> withNewCapabilitiesLike( Capabilities item);    public CapabilitiesNested<T> editCapabilities();    public Boolean isPrivileged();    public T withPrivileged( Boolean privileged);    public Boolean isRunAsNonRoot();    public T withRunAsNonRoot( Boolean runAsNonRoot);    public Long getRunAsUser();    public T withRunAsUser( Long runAsUser);    public SELinuxOptions getSeLinuxOptions();    public T withSeLinuxOptions( SELinuxOptions seLinuxOptions);    public SeLinuxOptionsNested<T> withNewSeLinuxOptions();    public SeLinuxOptionsNested<T> withNewSeLinuxOptionsLike( SELinuxOptions item);    public SeLinuxOptionsNested<T> editSeLinuxOptions();    public T withNewSeLinuxOptions( String level,  String role,  String type,  String user);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface CapabilitiesNested<N> extends Nested<N>, CapabilitiesFluent<CapabilitiesNested<N>>{
            public N endCapabilities();            public N and();        
}

    public interface SeLinuxOptionsNested<N> extends Nested<N>, SELinuxOptionsFluent<SeLinuxOptionsNested<N>>{
            public N endSeLinuxOptions();            public N and();        
}


}
