package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ServicePortFluent<T extends ServicePortFluent<T>> extends Fluent<T>{


    public String getName();    public T withName( String name);    public Integer getNodePort();    public T withNodePort( Integer nodePort);    public Integer getPort();    public T withPort( Integer port);    public String getProtocol();    public T withProtocol( String protocol);    public IntOrString getTargetPort();    public T withTargetPort( IntOrString targetPort);    public TargetPortNested<T> withNewTargetPort();    public TargetPortNested<T> withNewTargetPortLike( IntOrString item);    public TargetPortNested<T> editTargetPort();    public T withNewTargetPort( String strVal);    public T withNewTargetPort( Integer intVal);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface TargetPortNested<N> extends Nested<N>, IntOrStringFluent<TargetPortNested<N>>{
            public N endTargetPort();            public N and();        
}


}
