package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ConfigMapBuilder extends ConfigMapFluentImpl<ConfigMapBuilder> implements VisitableBuilder<ConfigMap,ConfigMapBuilder>{

     ConfigMapFluent<?> fluent;
public ConfigMapBuilder(){
    this(new ConfigMap());
}
public ConfigMapBuilder( ConfigMapFluent<?> fluent ){
    this(fluent, new ConfigMap());
}
public ConfigMapBuilder( ConfigMapFluent<?> fluent , ConfigMap instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withData(instance.getData()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); 
}
public ConfigMapBuilder( ConfigMap instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withData(instance.getData()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

public EditableConfigMap build(){
    EditableConfigMap buildable = new EditableConfigMap(fluent.getApiVersion(),fluent.getData(),fluent.getKind(),fluent.getMetadata());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ConfigMapBuilder that = (ConfigMapBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
