package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface DaemonSetFluent<T extends DaemonSetFluent<T>> extends Fluent<T>{


    public DaemonSet.ApiVersion getApiVersion();    public T withApiVersion( DaemonSet.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public DaemonSetSpec getSpec();    public T withSpec( DaemonSetSpec spec);    public SpecNested<T> withNewSpec();    public SpecNested<T> withNewSpecLike( DaemonSetSpec item);    public SpecNested<T> editSpec();    public DaemonSetStatus getStatus();    public T withStatus( DaemonSetStatus status);    public StatusNested<T> withNewStatus();    public StatusNested<T> withNewStatusLike( DaemonSetStatus item);    public StatusNested<T> editStatus();    public T withNewStatus( Integer currentNumberScheduled,  Integer desiredNumberScheduled,  Integer numberMisscheduled);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>, DaemonSetSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>, DaemonSetStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
