package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamedRoleBindingFluentImpl<T extends NamedRoleBindingFluent<T>> extends BaseFluent<T> implements NamedRoleBindingFluent<T>{

     String name;     VisitableBuilder<RoleBinding, ?> roleBinding;     Map<String, Object> additionalProperties = new HashMap();
public NamedRoleBindingFluentImpl(){
    
}
public NamedRoleBindingFluentImpl( NamedRoleBinding instance ){
    this.withName(instance.getName()); this.withRoleBinding(instance.getRoleBinding()); 
}

    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public RoleBinding getRoleBinding(){
    return this.roleBinding!=null?this.roleBinding.build():null;
    }
    public T withRoleBinding( RoleBinding roleBinding){
    if (roleBinding!=null){ this.roleBinding= new RoleBindingBuilder(roleBinding); _visitables.add(this.roleBinding);} return (T) this;
    }
    public RoleBindingNested<T> withNewRoleBinding(){
    return new RoleBindingNestedImpl<T>();
    }
    public RoleBindingNested<T> withNewRoleBindingLike( RoleBinding item){
    return new RoleBindingNestedImpl<T>(item);
    }
    public RoleBindingNested<T> editRoleBinding(){
    return withNewRoleBindingLike(getRoleBinding());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedRoleBindingFluentImpl that = (NamedRoleBindingFluentImpl) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (roleBinding != null ? !roleBinding.equals(that.roleBinding) :that.roleBinding != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class RoleBindingNestedImpl<N> extends RoleBindingFluentImpl<RoleBindingNested<N>> implements RoleBindingNested<N>{

        private final RoleBindingBuilder builder;
    
             RoleBindingNestedImpl ( RoleBinding item){
        this.builder = new RoleBindingBuilder(this, item);
        }
             RoleBindingNestedImpl (){
        this.builder = new RoleBindingBuilder(this);
        }
    
            public N endRoleBinding(){
            return and();
        }
            public N and(){
            return (N) NamedRoleBindingFluentImpl.this.withRoleBinding(builder.build());
        }
    
}


}
