package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface OAuthClientFluent<T extends OAuthClientFluent<T>> extends Fluent<T>{


    public OAuthClient.ApiVersion getApiVersion();    public T withApiVersion( OAuthClient.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToRedirectURIs( String ...items);    public T removeFromRedirectURIs( String ...items);    public List<String> getRedirectURIs();    public T withRedirectURIs( List<String> redirectURIs);    public T withRedirectURIs( String ...redirectURIs);    public Boolean isRespondWithChallenges();    public T withRespondWithChallenges( Boolean respondWithChallenges);    public String getSecret();    public T withSecret( String secret);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
