package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;

public interface PolicyBindingFluent<T extends PolicyBindingFluent<T>> extends Fluent<T>{


    public PolicyBinding.ApiVersion getApiVersion();    public T withApiVersion( PolicyBinding.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public String getLastModified();    public T withLastModified( String lastModified);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public ObjectReference getPolicyRef();    public T withPolicyRef( ObjectReference policyRef);    public PolicyRefNested<T> withNewPolicyRef();    public PolicyRefNested<T> withNewPolicyRefLike( ObjectReference item);    public PolicyRefNested<T> editPolicyRef();    public T addToRoleBindings( NamedRoleBinding ...items);    public T removeFromRoleBindings( NamedRoleBinding ...items);    public List<NamedRoleBinding> getRoleBindings();    public T withRoleBindings( List<NamedRoleBinding> roleBindings);    public T withRoleBindings( NamedRoleBinding ...roleBindings);    public RoleBindingsNested<T> addNewRoleBinding();    public RoleBindingsNested<T> addNewRoleBindingLike( NamedRoleBinding item);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface PolicyRefNested<N> extends Nested<N>, ObjectReferenceFluent<PolicyRefNested<N>>{
            public N endPolicyRef();            public N and();        
}

    public interface RoleBindingsNested<N> extends Nested<N>, NamedRoleBindingFluent<RoleBindingsNested<N>>{
            public N endRoleBinding();            public N and();        
}


}
