package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class RouteIngressBuilder extends RouteIngressFluentImpl<RouteIngressBuilder> implements VisitableBuilder<RouteIngress,RouteIngressBuilder>{

     RouteIngressFluent<?> fluent;
public RouteIngressBuilder(){
    this(new RouteIngress());
}
public RouteIngressBuilder( RouteIngressFluent<?> fluent ){
    this(fluent, new RouteIngress());
}
public RouteIngressBuilder( RouteIngressFluent<?> fluent , RouteIngress instance ){
    this.fluent = fluent; fluent.withConditions(instance.getConditions()); fluent.withHost(instance.getHost()); fluent.withRouterName(instance.getRouterName()); 
}
public RouteIngressBuilder( RouteIngress instance ){
    this.fluent = this; this.withConditions(instance.getConditions()); this.withHost(instance.getHost()); this.withRouterName(instance.getRouterName()); 
}

public EditableRouteIngress build(){
    EditableRouteIngress buildable = new EditableRouteIngress(fluent.getConditions(),fluent.getHost(),fluent.getRouterName());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RouteIngressBuilder that = (RouteIngressBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
