package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.List;

public class RouteIngressFluentImpl<T extends RouteIngressFluent<T>> extends BaseFluent<T> implements RouteIngressFluent<T>{

     List<VisitableBuilder<RouteIngressCondition, ?>> conditions = new ArrayList();     String host;     String routerName;     Map<String, Object> additionalProperties = new HashMap();
public RouteIngressFluentImpl(){
    
}
public RouteIngressFluentImpl( RouteIngress instance ){
    this.withConditions(instance.getConditions()); this.withHost(instance.getHost()); this.withRouterName(instance.getRouterName()); 
}

    public T addToConditions( RouteIngressCondition ...items){
    for (RouteIngressCondition item : items) {RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (T)this;
    }
    public T removeFromConditions( RouteIngressCondition ...items){
    for (RouteIngressCondition item : items) {RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (T)this;
    }
    public List<RouteIngressCondition> getConditions(){
    return build(conditions);
    }
    public T withConditions( List<RouteIngressCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (RouteIngressCondition item : conditions){this.addToConditions(item);}} return (T) this;
    }
    public T withConditions( RouteIngressCondition ...conditions){
    this.conditions.clear(); if (conditions != null) {for (RouteIngressCondition item :conditions){ this.addToConditions(item);}} return (T) this;
    }
    public ConditionsNested<T> addNewCondition(){
    return new ConditionsNestedImpl<T>();
    }
    public ConditionsNested<T> addNewConditionLike( RouteIngressCondition item){
    return new ConditionsNestedImpl<T>(item);
    }
    public T addNewCondition( String lastTransitionTime,  String message,  String reason,  String status,  String type){
    return addToConditions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
    }
    public String getHost(){
    return this.host;
    }
    public T withHost( String host){
    this.host=host; return (T) this;
    }
    public String getRouterName(){
    return this.routerName;
    }
    public T withRouterName( String routerName){
    this.routerName=routerName; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RouteIngressFluentImpl that = (RouteIngressFluentImpl) o;
if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
if (host != null ? !host.equals(that.host) :that.host != null) return false;
if (routerName != null ? !routerName.equals(that.routerName) :that.routerName != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ConditionsNestedImpl<N> extends RouteIngressConditionFluentImpl<ConditionsNested<N>> implements ConditionsNested<N>{

        private final RouteIngressConditionBuilder builder;
    
             ConditionsNestedImpl (){
        this.builder = new RouteIngressConditionBuilder(this);
        }
             ConditionsNestedImpl ( RouteIngressCondition item){
        this.builder = new RouteIngressConditionBuilder(this, item);
        }
    
            public N endCondition(){
            return and();
        }
            public N and(){
            return (N) RouteIngressFluentImpl.this.addToConditions(builder.build());
        }
    
}


}
