package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ConfigBuilder extends ConfigFluentImpl<ConfigBuilder> implements VisitableBuilder<Config,ConfigBuilder>{

     ConfigFluent<?> fluent;
public ConfigBuilder(){
    this(new Config());
}
public ConfigBuilder( ConfigFluent<?> fluent ){
    this(fluent, new Config());
}
public ConfigBuilder( ConfigFluent<?> fluent , Config instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withClusters(instance.getClusters()); fluent.withContexts(instance.getContexts()); fluent.withCurrentContext(instance.getCurrentContext()); fluent.withExtensions(instance.getExtensions()); fluent.withKind(instance.getKind()); fluent.withPreferences(instance.getPreferences()); fluent.withUsers(instance.getUsers()); 
}
public ConfigBuilder( Config instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withClusters(instance.getClusters()); this.withContexts(instance.getContexts()); this.withCurrentContext(instance.getCurrentContext()); this.withExtensions(instance.getExtensions()); this.withKind(instance.getKind()); this.withPreferences(instance.getPreferences()); this.withUsers(instance.getUsers()); 
}

public Config build(){
    Config buildable = new Config(fluent.getApiVersion(),fluent.getClusters(),fluent.getContexts(),fluent.getCurrentContext(),fluent.getExtensions(),fluent.getKind(),fluent.getPreferences(),fluent.getUsers());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ConfigBuilder that = (ConfigBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
