package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class EndpointPortFluentImpl<T extends EndpointPortFluent<T>> extends BaseFluent<T> implements EndpointPortFluent<T>{

     String name;     Integer port;     String protocol;     Map<String, Object> additionalProperties = new HashMap();
public EndpointPortFluentImpl(){
    
}
public EndpointPortFluentImpl( EndpointPort instance ){
    this.withName(instance.getName()); this.withPort(instance.getPort()); this.withProtocol(instance.getProtocol()); 
}

    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public Integer getPort(){
    return this.port;
    }
    public T withPort( Integer port){
    this.port=port; return (T) this;
    }
    public String getProtocol(){
    return this.protocol;
    }
    public T withProtocol( String protocol){
    this.protocol=protocol; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EndpointPortFluentImpl that = (EndpointPortFluentImpl) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (port != null ? !port.equals(that.port) :that.port != null) return false;
if (protocol != null ? !protocol.equals(that.protocol) :that.protocol != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
