package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class EndpointSubsetBuilder extends EndpointSubsetFluentImpl<EndpointSubsetBuilder> implements VisitableBuilder<EndpointSubset,EndpointSubsetBuilder>{

     EndpointSubsetFluent<?> fluent;
public EndpointSubsetBuilder(){
    this(new EndpointSubset());
}
public EndpointSubsetBuilder( EndpointSubsetFluent<?> fluent ){
    this(fluent, new EndpointSubset());
}
public EndpointSubsetBuilder( EndpointSubsetFluent<?> fluent , EndpointSubset instance ){
    this.fluent = fluent; fluent.withAddresses(instance.getAddresses()); fluent.withNotReadyAddresses(instance.getNotReadyAddresses()); fluent.withPorts(instance.getPorts()); 
}
public EndpointSubsetBuilder( EndpointSubset instance ){
    this.fluent = this; this.withAddresses(instance.getAddresses()); this.withNotReadyAddresses(instance.getNotReadyAddresses()); this.withPorts(instance.getPorts()); 
}

public EndpointSubset build(){
    EndpointSubset buildable = new EndpointSubset(fluent.getAddresses(),fluent.getNotReadyAddresses(),fluent.getPorts());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
EndpointSubsetBuilder that = (EndpointSubsetBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
