package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class EndpointsListBuilder extends EndpointsListFluentImpl<EndpointsListBuilder> implements VisitableBuilder<EndpointsList,EndpointsListBuilder>{

     EndpointsListFluent<?> fluent;
public EndpointsListBuilder(){
    this(new EndpointsList());
}
public EndpointsListBuilder( EndpointsListFluent<?> fluent ){
    this(fluent, new EndpointsList());
}
public EndpointsListBuilder( EndpointsListFluent<?> fluent , EndpointsList instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withItems(instance.getItems()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); 
}
public EndpointsListBuilder( EndpointsList instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withItems(instance.getItems()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

public EndpointsList build(){
    EndpointsList buildable = new EndpointsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
EndpointsListBuilder that = (EndpointsListBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
