package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ListMetaBuilder extends ListMetaFluentImpl<ListMetaBuilder> implements VisitableBuilder<ListMeta,ListMetaBuilder>{

     ListMetaFluent<?> fluent;
public ListMetaBuilder(){
    this(new ListMeta());
}
public ListMetaBuilder( ListMetaFluent<?> fluent ){
    this(fluent, new ListMeta());
}
public ListMetaBuilder( ListMetaFluent<?> fluent , ListMeta instance ){
    this.fluent = fluent; fluent.withResourceVersion(instance.getResourceVersion()); fluent.withSelfLink(instance.getSelfLink()); 
}
public ListMetaBuilder( ListMeta instance ){
    this.fluent = this; this.withResourceVersion(instance.getResourceVersion()); this.withSelfLink(instance.getSelfLink()); 
}

public ListMeta build(){
    ListMeta buildable = new ListMeta(fluent.getResourceVersion(),fluent.getSelfLink());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ListMetaBuilder that = (ListMetaBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
