package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PersistentVolumeFluent<T extends PersistentVolumeFluent<T>> extends Fluent<T>{


    public String getApiVersion();    public T withApiVersion( String apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public PersistentVolumeSpec getSpec();    public T withSpec( PersistentVolumeSpec spec);    public SpecNested<T> withNewSpec();    public SpecNested<T> withNewSpecLike( PersistentVolumeSpec item);    public SpecNested<T> editSpec();    public PersistentVolumeStatus getStatus();    public T withStatus( PersistentVolumeStatus status);    public StatusNested<T> withNewStatus();    public StatusNested<T> withNewStatusLike( PersistentVolumeStatus item);    public StatusNested<T> editStatus();    public T withNewStatus( String message,  String phase,  String reason);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>, PersistentVolumeSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>, PersistentVolumeStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
