package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class SecurityContextBuilder extends SecurityContextFluentImpl<SecurityContextBuilder> implements VisitableBuilder<SecurityContext,SecurityContextBuilder>{

     SecurityContextFluent<?> fluent;
public SecurityContextBuilder(){
    this(new SecurityContext());
}
public SecurityContextBuilder( SecurityContextFluent<?> fluent ){
    this(fluent, new SecurityContext());
}
public SecurityContextBuilder( SecurityContextFluent<?> fluent , SecurityContext instance ){
    this.fluent = fluent; fluent.withCapabilities(instance.getCapabilities()); fluent.withPrivileged(instance.getPrivileged()); fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); fluent.withRunAsNonRoot(instance.getRunAsNonRoot()); fluent.withRunAsUser(instance.getRunAsUser()); fluent.withSeLinuxOptions(instance.getSeLinuxOptions()); 
}
public SecurityContextBuilder( SecurityContext instance ){
    this.fluent = this; this.withCapabilities(instance.getCapabilities()); this.withPrivileged(instance.getPrivileged()); this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); this.withRunAsNonRoot(instance.getRunAsNonRoot()); this.withRunAsUser(instance.getRunAsUser()); this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
}

public SecurityContext build(){
    SecurityContext buildable = new SecurityContext(fluent.getCapabilities(),fluent.isPrivileged(),fluent.isReadOnlyRootFilesystem(),fluent.isRunAsNonRoot(),fluent.getRunAsUser(),fluent.getSeLinuxOptions());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SecurityContextBuilder that = (SecurityContextBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
