package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public interface DeploymentSpecFluent<T extends DeploymentSpecFluent<T>> extends Fluent<T>{


    public Integer getMinReadySeconds();    public T withMinReadySeconds( Integer minReadySeconds);    public Boolean isPaused();    public T withPaused( Boolean paused);    public Integer getReplicas();    public T withReplicas( Integer replicas);    public Integer getRevisionHistoryLimit();    public T withRevisionHistoryLimit( Integer revisionHistoryLimit);    public RollbackConfig getRollbackTo();    public T withRollbackTo( RollbackConfig rollbackTo);    public RollbackToNested<T> withNewRollbackTo();    public RollbackToNested<T> withNewRollbackToLike( RollbackConfig item);    public RollbackToNested<T> editRollbackTo();    public T withNewRollbackTo( Long revision);    public LabelSelector getSelector();    public T withSelector( LabelSelector selector);    public SelectorNested<T> withNewSelector();    public SelectorNested<T> withNewSelectorLike( LabelSelector item);    public SelectorNested<T> editSelector();    public DeploymentStrategy getStrategy();    public T withStrategy( DeploymentStrategy strategy);    public StrategyNested<T> withNewStrategy();    public StrategyNested<T> withNewStrategyLike( DeploymentStrategy item);    public StrategyNested<T> editStrategy();    public PodTemplateSpec getTemplate();    public T withTemplate( PodTemplateSpec template);    public TemplateNested<T> withNewTemplate();    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item);    public TemplateNested<T> editTemplate();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface RollbackToNested<N> extends Nested<N>, RollbackConfigFluent<RollbackToNested<N>>{
            public N endRollbackTo();            public N and();        
}

    public interface SelectorNested<N> extends Nested<N>, LabelSelectorFluent<SelectorNested<N>>{
            public N endSelector();            public N and();        
}

    public interface StrategyNested<N> extends Nested<N>, DeploymentStrategyFluent<StrategyNested<N>>{
            public N endStrategy();            public N and();        
}

    public interface TemplateNested<N> extends Nested<N>, PodTemplateSpecFluent<TemplateNested<N>>{
            public N endTemplate();            public N and();        
}


}
