package io.fabric8.kubernetes.api.model.extensions;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class IngressTLSFluentImpl<T extends IngressTLSFluent<T>> extends BaseFluent<T> implements IngressTLSFluent<T>{

     List<String> hosts = new ArrayList();     String secretName;     Map<String, Object> additionalProperties = new HashMap();
public IngressTLSFluentImpl(){
    
}
public IngressTLSFluentImpl( IngressTLS instance ){
    this.withHosts(instance.getHosts()); this.withSecretName(instance.getSecretName()); 
}

    public T addToHosts( String ...items){
    for (String item : items) {this.hosts.add(item);} return (T)this;
    }
    public T removeFromHosts( String ...items){
    for (String item : items) {this.hosts.remove(item);} return (T)this;
    }
    public List<String> getHosts(){
    return this.hosts;
    }
    public T withHosts( List<String> hosts){
    this.hosts.clear();if (hosts != null) {for (String item : hosts){this.addToHosts(item);}} return (T) this;
    }
    public T withHosts( String ...hosts){
    this.hosts.clear(); if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (T) this;
    }
    public String getSecretName(){
    return this.secretName;
    }
    public T withSecretName( String secretName){
    this.secretName=secretName; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
IngressTLSFluentImpl that = (IngressTLSFluentImpl) o;
if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
