package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class BuildSourceBuilder extends BuildSourceFluentImpl<BuildSourceBuilder> implements VisitableBuilder<BuildSource,BuildSourceBuilder>{

     BuildSourceFluent<?> fluent;
public BuildSourceBuilder(){
    this(new BuildSource());
}
public BuildSourceBuilder( BuildSourceFluent<?> fluent ){
    this(fluent, new BuildSource());
}
public BuildSourceBuilder( BuildSourceFluent<?> fluent , BuildSource instance ){
    this.fluent = fluent; fluent.withBinary(instance.getBinary()); fluent.withContextDir(instance.getContextDir()); fluent.withDockerfile(instance.getDockerfile()); fluent.withGit(instance.getGit()); fluent.withImages(instance.getImages()); fluent.withSecrets(instance.getSecrets()); fluent.withSourceSecret(instance.getSourceSecret()); fluent.withType(instance.getType()); 
}
public BuildSourceBuilder( BuildSource instance ){
    this.fluent = this; this.withBinary(instance.getBinary()); this.withContextDir(instance.getContextDir()); this.withDockerfile(instance.getDockerfile()); this.withGit(instance.getGit()); this.withImages(instance.getImages()); this.withSecrets(instance.getSecrets()); this.withSourceSecret(instance.getSourceSecret()); this.withType(instance.getType()); 
}

public BuildSource build(){
    BuildSource buildable = new BuildSource(fluent.getBinary(),fluent.getContextDir(),fluent.getDockerfile(),fluent.getGit(),fluent.getImages(),fluent.getSecrets(),fluent.getSourceSecret(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BuildSourceBuilder that = (BuildSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
