package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

public interface BuildSourceFluent<T extends BuildSourceFluent<T>> extends Fluent<T>{


    public BinaryBuildSource getBinary();    public T withBinary( BinaryBuildSource binary);    public BinaryNested<T> withNewBinary();    public BinaryNested<T> withNewBinaryLike( BinaryBuildSource item);    public BinaryNested<T> editBinary();    public T withNewBinary( String asFile);    public String getContextDir();    public T withContextDir( String contextDir);    public String getDockerfile();    public T withDockerfile( String dockerfile);    public GitBuildSource getGit();    public T withGit( GitBuildSource git);    public GitNested<T> withNewGit();    public GitNested<T> withNewGitLike( GitBuildSource item);    public GitNested<T> editGit();    public T withNewGit( String httpProxy,  String httpsProxy,  String ref,  String uri);    public T addToImages( ImageSource ...items);    public T removeFromImages( ImageSource ...items);    public List<ImageSource> getImages();    public T withImages( List<ImageSource> images);    public T withImages( ImageSource ...images);    public ImagesNested<T> addNewImage();    public ImagesNested<T> addNewImageLike( ImageSource item);    public T addToSecrets( SecretBuildSource ...items);    public T removeFromSecrets( SecretBuildSource ...items);    public List<SecretBuildSource> getSecrets();    public T withSecrets( List<SecretBuildSource> secrets);    public T withSecrets( SecretBuildSource ...secrets);    public SecretsNested<T> addNewSecret();    public SecretsNested<T> addNewSecretLike( SecretBuildSource item);    public LocalObjectReference getSourceSecret();    public T withSourceSecret( LocalObjectReference sourceSecret);    public SourceSecretNested<T> withNewSourceSecret();    public SourceSecretNested<T> withNewSourceSecretLike( LocalObjectReference item);    public SourceSecretNested<T> editSourceSecret();    public T withNewSourceSecret( String name);    public String getType();    public T withType( String type);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface BinaryNested<N> extends Nested<N>, BinaryBuildSourceFluent<BinaryNested<N>>{
            public N and();            public N endBinary();        
}

    public interface GitNested<N> extends Nested<N>, GitBuildSourceFluent<GitNested<N>>{
            public N and();            public N endGit();        
}

    public interface ImagesNested<N> extends Nested<N>, ImageSourceFluent<ImagesNested<N>>{
            public N and();            public N endImage();        
}

    public interface SecretsNested<N> extends Nested<N>, SecretBuildSourceFluent<SecretsNested<N>>{
            public N and();            public N endSecret();        
}

    public interface SourceSecretNested<N> extends Nested<N>, LocalObjectReferenceFluent<SourceSecretNested<N>>{
            public N and();            public N endSourceSecret();        
}


}
