package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class DeploymentConfigStatusBuilder extends DeploymentConfigStatusFluentImpl<DeploymentConfigStatusBuilder> implements VisitableBuilder<DeploymentConfigStatus,DeploymentConfigStatusBuilder>{

     DeploymentConfigStatusFluent<?> fluent;
public DeploymentConfigStatusBuilder(){
    this(new DeploymentConfigStatus());
}
public DeploymentConfigStatusBuilder( DeploymentConfigStatusFluent<?> fluent ){
    this(fluent, new DeploymentConfigStatus());
}
public DeploymentConfigStatusBuilder( DeploymentConfigStatusFluent<?> fluent , DeploymentConfigStatus instance ){
    this.fluent = fluent; fluent.withDetails(instance.getDetails()); fluent.withLatestVersion(instance.getLatestVersion()); fluent.withObservedGeneration(instance.getObservedGeneration()); 
}
public DeploymentConfigStatusBuilder( DeploymentConfigStatus instance ){
    this.fluent = this; this.withDetails(instance.getDetails()); this.withLatestVersion(instance.getLatestVersion()); this.withObservedGeneration(instance.getObservedGeneration()); 
}

public DeploymentConfigStatus build(){
    DeploymentConfigStatus buildable = new DeploymentConfigStatus(fluent.getDetails(),fluent.getLatestVersion(),fluent.getObservedGeneration());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DeploymentConfigStatusBuilder that = (DeploymentConfigStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
