package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ConfigFluent<T extends ConfigFluent<T>> extends Fluent<T>{


    public String getApiVersion();    public T withApiVersion( String apiVersion);    public T addToClusters( NamedCluster ...items);    public T removeFromClusters( NamedCluster ...items);    public List<NamedCluster> getClusters();    public T withClusters( List<NamedCluster> clusters);    public T withClusters( NamedCluster ...clusters);    public ClustersNested<T> addNewCluster();    public ClustersNested<T> addNewClusterLike( NamedCluster item);    public T addToContexts( NamedContext ...items);    public T removeFromContexts( NamedContext ...items);    public List<NamedContext> getContexts();    public T withContexts( List<NamedContext> contexts);    public T withContexts( NamedContext ...contexts);    public ContextsNested<T> addNewContext();    public ContextsNested<T> addNewContextLike( NamedContext item);    public String getCurrentContext();    public T withCurrentContext( String currentContext);    public T addToExtensions( NamedExtension ...items);    public T removeFromExtensions( NamedExtension ...items);    public List<NamedExtension> getExtensions();    public T withExtensions( List<NamedExtension> extensions);    public T withExtensions( NamedExtension ...extensions);    public ExtensionsNested<T> addNewExtension();    public ExtensionsNested<T> addNewExtensionLike( NamedExtension item);    public String getKind();    public T withKind( String kind);    public Preferences getPreferences();    public T withPreferences( Preferences preferences);    public PreferencesNested<T> withNewPreferences();    public PreferencesNested<T> withNewPreferencesLike( Preferences item);    public PreferencesNested<T> editPreferences();    public T addToUsers( NamedAuthInfo ...items);    public T removeFromUsers( NamedAuthInfo ...items);    public List<NamedAuthInfo> getUsers();    public T withUsers( List<NamedAuthInfo> users);    public T withUsers( NamedAuthInfo ...users);    public UsersNested<T> addNewUser();    public UsersNested<T> addNewUserLike( NamedAuthInfo item);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ClustersNested<N> extends Nested<N>, NamedClusterFluent<ClustersNested<N>>{
            public N endCluster();            public N and();        
}

    public interface ContextsNested<N> extends Nested<N>, NamedContextFluent<ContextsNested<N>>{
            public N endContext();            public N and();        
}

    public interface ExtensionsNested<N> extends Nested<N>, NamedExtensionFluent<ExtensionsNested<N>>{
            public N and();            public N endExtension();        
}

    public interface PreferencesNested<N> extends Nested<N>, PreferencesFluent<PreferencesNested<N>>{
            public N and();            public N endPreferences();        
}

    public interface UsersNested<N> extends Nested<N>, NamedAuthInfoFluent<UsersNested<N>>{
            public N and();            public N endUser();        
}


}
