package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface EventFluent<T extends EventFluent<T>> extends Fluent<T>{


    public String getApiVersion();    public T withApiVersion( String apiVersion);    public Integer getCount();    public T withCount( Integer count);    public String getFirstTimestamp();    public T withFirstTimestamp( String firstTimestamp);    public ObjectReference getInvolvedObject();    public T withInvolvedObject( ObjectReference involvedObject);    public InvolvedObjectNested<T> withNewInvolvedObject();    public InvolvedObjectNested<T> withNewInvolvedObjectLike( ObjectReference item);    public InvolvedObjectNested<T> editInvolvedObject();    public String getKind();    public T withKind( String kind);    public String getLastTimestamp();    public T withLastTimestamp( String lastTimestamp);    public String getMessage();    public T withMessage( String message);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public String getReason();    public T withReason( String reason);    public EventSource getSource();    public T withSource( EventSource source);    public SourceNested<T> withNewSource();    public SourceNested<T> withNewSourceLike( EventSource item);    public SourceNested<T> editSource();    public T withNewSource( String component,  String host);    public String getType();    public T withType( String type);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface InvolvedObjectNested<N> extends Nested<N>, ObjectReferenceFluent<InvolvedObjectNested<N>>{
            public N and();            public N endInvolvedObject();        
}

    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SourceNested<N> extends Nested<N>, EventSourceFluent<SourceNested<N>>{
            public N and();            public N endSource();        
}


}
