package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ObjectMetaBuilder extends ObjectMetaFluentImpl<ObjectMetaBuilder> implements VisitableBuilder<ObjectMeta,ObjectMetaBuilder>{

     ObjectMetaFluent<?> fluent;
public ObjectMetaBuilder(){
    this(new ObjectMeta());
}
public ObjectMetaBuilder( ObjectMetaFluent<?> fluent ){
    this(fluent, new ObjectMeta());
}
public ObjectMetaBuilder( ObjectMetaFluent<?> fluent , ObjectMeta instance ){
    this.fluent = fluent; fluent.withAnnotations(instance.getAnnotations()); fluent.withCreationTimestamp(instance.getCreationTimestamp()); fluent.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds()); fluent.withDeletionTimestamp(instance.getDeletionTimestamp()); fluent.withGenerateName(instance.getGenerateName()); fluent.withGeneration(instance.getGeneration()); fluent.withLabels(instance.getLabels()); fluent.withName(instance.getName()); fluent.withNamespace(instance.getNamespace()); fluent.withResourceVersion(instance.getResourceVersion()); fluent.withSelfLink(instance.getSelfLink()); fluent.withUid(instance.getUid()); 
}
public ObjectMetaBuilder( ObjectMeta instance ){
    this.fluent = this; this.withAnnotations(instance.getAnnotations()); this.withCreationTimestamp(instance.getCreationTimestamp()); this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds()); this.withDeletionTimestamp(instance.getDeletionTimestamp()); this.withGenerateName(instance.getGenerateName()); this.withGeneration(instance.getGeneration()); this.withLabels(instance.getLabels()); this.withName(instance.getName()); this.withNamespace(instance.getNamespace()); this.withResourceVersion(instance.getResourceVersion()); this.withSelfLink(instance.getSelfLink()); this.withUid(instance.getUid()); 
}

public ObjectMeta build(){
    ObjectMeta buildable = new ObjectMeta(fluent.getAnnotations(),fluent.getCreationTimestamp(),fluent.getDeletionGracePeriodSeconds(),fluent.getDeletionTimestamp(),fluent.getGenerateName(),fluent.getGeneration(),fluent.getLabels(),fluent.getName(),fluent.getNamespace(),fluent.getResourceVersion(),fluent.getSelfLink(),fluent.getUid());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ObjectMetaBuilder that = (ObjectMetaBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
