package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ServiceAccountListFluent<T extends ServiceAccountListFluent<T>> extends Fluent<T>{


    public String getApiVersion();    public T withApiVersion( String apiVersion);    public T addToItems( ServiceAccount ...items);    public T removeFromItems( ServiceAccount ...items);    public List<ServiceAccount> getItems();    public T withItems( List<ServiceAccount> items);    public T withItems( ServiceAccount ...items);    public ItemsNested<T> addNewItem();    public ItemsNested<T> addNewItemLike( ServiceAccount item);    public String getKind();    public T withKind( String kind);    public ListMeta getMetadata();    public T withMetadata( ListMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ListMeta item);    public MetadataNested<T> editMetadata();    public T withNewMetadata( String resourceVersion,  String selfLink);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ItemsNested<N> extends Nested<N>, ServiceAccountFluent<ItemsNested<N>>{
            public N endItem();            public N and();        
}

    public interface MetadataNested<N> extends Nested<N>, ListMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
