package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface ImageSourceFluent<T extends ImageSourceFluent<T>> extends Fluent<T>{


    public ObjectReference getFrom();    public T withFrom( ObjectReference from);    public FromNested<T> withNewFrom();    public FromNested<T> withNewFromLike( ObjectReference item);    public FromNested<T> editFrom();    public T addToPaths( ImageSourcePath ...items);    public T removeFromPaths( ImageSourcePath ...items);    public List<ImageSourcePath> getPaths();    public T withPaths( List<ImageSourcePath> paths);    public T withPaths( ImageSourcePath ...paths);    public PathsNested<T> addNewPath();    public PathsNested<T> addNewPathLike( ImageSourcePath item);    public T addNewPath( String destinationDir,  String sourcePath);    public LocalObjectReference getPullSecret();    public T withPullSecret( LocalObjectReference pullSecret);    public PullSecretNested<T> withNewPullSecret();    public PullSecretNested<T> withNewPullSecretLike( LocalObjectReference item);    public PullSecretNested<T> editPullSecret();    public T withNewPullSecret( String name);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface FromNested<N> extends Nested<N>, ObjectReferenceFluent<FromNested<N>>{
            public N endFrom();            public N and();        
}

    public interface PathsNested<N> extends Nested<N>, ImageSourcePathFluent<PathsNested<N>>{
            public N and();            public N endPath();        
}

    public interface PullSecretNested<N> extends Nested<N>, LocalObjectReferenceFluent<PullSecretNested<N>>{
            public N and();            public N endPullSecret();        
}


}
