package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class SecretBuildSourceFluentImpl<T extends SecretBuildSourceFluent<T>> extends BaseFluent<T> implements SecretBuildSourceFluent<T>{

     String destinationDir;     VisitableBuilder<LocalObjectReference, ?> secret;     Map<String, Object> additionalProperties = new HashMap();
public SecretBuildSourceFluentImpl(){
    
}
public SecretBuildSourceFluentImpl( SecretBuildSource instance ){
    this.withDestinationDir(instance.getDestinationDir()); this.withSecret(instance.getSecret()); 
}

    public String getDestinationDir(){
    return this.destinationDir;
    }
    public T withDestinationDir( String destinationDir){
    this.destinationDir=destinationDir; return (T) this;
    }
    public LocalObjectReference getSecret(){
    return this.secret!=null?this.secret.build():null;
    }
    public T withSecret( LocalObjectReference secret){
    if (secret!=null){ this.secret= new LocalObjectReferenceBuilder(secret); _visitables.add(this.secret);} return (T) this;
    }
    public SecretNested<T> withNewSecret(){
    return new SecretNestedImpl<T>();
    }
    public SecretNested<T> withNewSecretLike( LocalObjectReference item){
    return new SecretNestedImpl<T>(item);
    }
    public SecretNested<T> editSecret(){
    return withNewSecretLike(getSecret());
    }
    public T withNewSecret( String name){
    return withSecret(new LocalObjectReference(name));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SecretBuildSourceFluentImpl that = (SecretBuildSourceFluentImpl) o;
if (destinationDir != null ? !destinationDir.equals(that.destinationDir) :that.destinationDir != null) return false;
if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class SecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<SecretNested<N>> implements SecretNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             SecretNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             SecretNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) SecretBuildSourceFluentImpl.this.withSecret(builder.build());
        }
            public N endSecret(){
            return and();
        }
    
}


}
