package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class TagEventConditionBuilder extends TagEventConditionFluentImpl<TagEventConditionBuilder> implements VisitableBuilder<TagEventCondition,TagEventConditionBuilder>{

     TagEventConditionFluent<?> fluent;
public TagEventConditionBuilder(){
    this(new TagEventCondition());
}
public TagEventConditionBuilder( TagEventConditionFluent<?> fluent ){
    this(fluent, new TagEventCondition());
}
public TagEventConditionBuilder( TagEventConditionFluent<?> fluent , TagEventCondition instance ){
    this.fluent = fluent; fluent.withGeneration(instance.getGeneration()); fluent.withLastTransitionTime(instance.getLastTransitionTime()); fluent.withMessage(instance.getMessage()); fluent.withReason(instance.getReason()); fluent.withStatus(instance.getStatus()); fluent.withType(instance.getType()); 
}
public TagEventConditionBuilder( TagEventCondition instance ){
    this.fluent = this; this.withGeneration(instance.getGeneration()); this.withLastTransitionTime(instance.getLastTransitionTime()); this.withMessage(instance.getMessage()); this.withReason(instance.getReason()); this.withStatus(instance.getStatus()); this.withType(instance.getType()); 
}

public TagEventCondition build(){
    TagEventCondition buildable = new TagEventCondition(fluent.getGeneration(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
TagEventConditionBuilder that = (TagEventConditionBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
