/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.ContextFluent;
import io.fabric8.kubernetes.api.model.ContextFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContextBuilder
extends ContextFluentImpl<ContextBuilder>
implements VisitableBuilder<Context, ContextBuilder> {
    ContextFluent<?> fluent;

    public ContextBuilder() {
        this(new Context());
    }

    public ContextBuilder(ContextFluent<?> fluent) {
        this(fluent, new Context());
    }

    public ContextBuilder(ContextFluent<?> fluent, Context instance) {
        this.fluent = fluent;
        fluent.withCluster(instance.getCluster());
        fluent.withExtensions(instance.getExtensions());
        fluent.withNamespace(instance.getNamespace());
        fluent.withUser(instance.getUser());
    }

    public ContextBuilder(Context instance) {
        this.fluent = this;
        this.withCluster(instance.getCluster());
        this.withExtensions(instance.getExtensions());
        this.withNamespace(instance.getNamespace());
        this.withUser(instance.getUser());
    }

    @Override
    public Context build() {
        Context buildable = new Context(this.fluent.getCluster(), this.fluent.getExtensions(), this.fluent.getNamespace(), this.fluent.getUser());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContextBuilder that = (ContextBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

