/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "count", "firstTimestamp", "involvedObject", "kind", "lastTimestamp", "message", "metadata", "reason", "source", "type"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Event
implements HasMetadata {
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "v1";
    @JsonProperty(value="count")
    private Integer count;
    @JsonProperty(value="firstTimestamp")
    private String firstTimestamp;
    @JsonProperty(value="involvedObject")
    @Valid
    private ObjectReference involvedObject;
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "Event";
    @JsonProperty(value="lastTimestamp")
    private String lastTimestamp;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="metadata")
    @Valid
    @CheckObjectMeta(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$", max=253)
    private ObjectMeta metadata;
    @JsonProperty(value="reason")
    private String reason;
    @JsonProperty(value="source")
    @Valid
    private EventSource source;
    @JsonProperty(value="type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Event() {
    }

    public Event(String apiVersion, Integer count, String firstTimestamp, ObjectReference involvedObject, String kind, String lastTimestamp, String message, ObjectMeta metadata, String reason, EventSource source, String type) {
        this.apiVersion = apiVersion;
        this.count = count;
        this.firstTimestamp = firstTimestamp;
        this.involvedObject = involvedObject;
        this.kind = kind;
        this.lastTimestamp = lastTimestamp;
        this.message = message;
        this.metadata = metadata;
        this.reason = reason;
        this.source = source;
        this.type = type;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    @JsonProperty(value="count")
    public void setCount(Integer count) {
        this.count = count;
    }

    @JsonProperty(value="firstTimestamp")
    public String getFirstTimestamp() {
        return this.firstTimestamp;
    }

    @JsonProperty(value="firstTimestamp")
    public void setFirstTimestamp(String firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
    }

    @JsonProperty(value="involvedObject")
    public ObjectReference getInvolvedObject() {
        return this.involvedObject;
    }

    @JsonProperty(value="involvedObject")
    public void setInvolvedObject(ObjectReference involvedObject) {
        this.involvedObject = involvedObject;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="lastTimestamp")
    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    @JsonProperty(value="lastTimestamp")
    public void setLastTimestamp(String lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @JsonProperty(value="source")
    public EventSource getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(EventSource source) {
        this.source = source;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "Event(apiVersion=" + this.getApiVersion() + ", count=" + this.getCount() + ", firstTimestamp=" + this.getFirstTimestamp() + ", involvedObject=" + this.getInvolvedObject() + ", kind=" + this.getKind() + ", lastTimestamp=" + this.getLastTimestamp() + ", message=" + this.getMessage() + ", metadata=" + this.getMetadata() + ", reason=" + this.getReason() + ", source=" + this.getSource() + ", type=" + this.getType() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        String this$firstTimestamp = this.getFirstTimestamp();
        String other$firstTimestamp = other.getFirstTimestamp();
        if (this$firstTimestamp == null ? other$firstTimestamp != null : !this$firstTimestamp.equals(other$firstTimestamp)) {
            return false;
        }
        ObjectReference this$involvedObject = this.getInvolvedObject();
        ObjectReference other$involvedObject = other.getInvolvedObject();
        if (this$involvedObject == null ? other$involvedObject != null : !((Object)this$involvedObject).equals(other$involvedObject)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        String this$lastTimestamp = this.getLastTimestamp();
        String other$lastTimestamp = other.getLastTimestamp();
        if (this$lastTimestamp == null ? other$lastTimestamp != null : !this$lastTimestamp.equals(other$lastTimestamp)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        EventSource this$source = this.getSource();
        EventSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 0 : $apiVersion.hashCode());
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 0 : ((Object)$count).hashCode());
        String $firstTimestamp = this.getFirstTimestamp();
        result = result * 59 + ($firstTimestamp == null ? 0 : $firstTimestamp.hashCode());
        ObjectReference $involvedObject = this.getInvolvedObject();
        result = result * 59 + ($involvedObject == null ? 0 : ((Object)$involvedObject).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 0 : $kind.hashCode());
        String $lastTimestamp = this.getLastTimestamp();
        result = result * 59 + ($lastTimestamp == null ? 0 : $lastTimestamp.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 0 : $message.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 0 : ((Object)$metadata).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 0 : $reason.hashCode());
        EventSource $source = this.getSource();
        result = result * 59 + ($source == null ? 0 : ((Object)$source).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 0 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

