/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.FSGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.FSGroupStrategyOptionsFluent;
import io.fabric8.kubernetes.api.model.FSGroupStrategyOptionsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class FSGroupStrategyOptionsBuilder
extends FSGroupStrategyOptionsFluentImpl<FSGroupStrategyOptionsBuilder>
implements VisitableBuilder<FSGroupStrategyOptions, FSGroupStrategyOptionsBuilder> {
    FSGroupStrategyOptionsFluent<?> fluent;

    public FSGroupStrategyOptionsBuilder() {
        this(new FSGroupStrategyOptions());
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent) {
        this(fluent, new FSGroupStrategyOptions());
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent, FSGroupStrategyOptions instance) {
        this.fluent = fluent;
        fluent.withRanges(instance.getRanges());
        fluent.withType(instance.getType());
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptions instance) {
        this.fluent = this;
        this.withRanges(instance.getRanges());
        this.withType(instance.getType());
    }

    @Override
    public FSGroupStrategyOptions build() {
        FSGroupStrategyOptions buildable = new FSGroupStrategyOptions(this.fluent.getRanges(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FSGroupStrategyOptionsBuilder that = (FSGroupStrategyOptionsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

