/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSource;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class GitRepoVolumeSourceBuilder
extends GitRepoVolumeSourceFluentImpl<GitRepoVolumeSourceBuilder>
implements VisitableBuilder<GitRepoVolumeSource, GitRepoVolumeSourceBuilder> {
    GitRepoVolumeSourceFluent<?> fluent;

    public GitRepoVolumeSourceBuilder() {
        this(new GitRepoVolumeSource());
    }

    public GitRepoVolumeSourceBuilder(GitRepoVolumeSourceFluent<?> fluent) {
        this(fluent, new GitRepoVolumeSource());
    }

    public GitRepoVolumeSourceBuilder(GitRepoVolumeSourceFluent<?> fluent, GitRepoVolumeSource instance) {
        this.fluent = fluent;
        fluent.withDirectory(instance.getDirectory());
        fluent.withRepository(instance.getRepository());
        fluent.withRevision(instance.getRevision());
    }

    public GitRepoVolumeSourceBuilder(GitRepoVolumeSource instance) {
        this.fluent = this;
        this.withDirectory(instance.getDirectory());
        this.withRepository(instance.getRepository());
        this.withRevision(instance.getRevision());
    }

    @Override
    public GitRepoVolumeSource build() {
        GitRepoVolumeSource buildable = new GitRepoVolumeSource(this.fluent.getDirectory(), this.fluent.getRepository(), this.fluent.getRevision());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitRepoVolumeSourceBuilder that = (GitRepoVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

