/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NFSVolumeSourceBuilder
extends NFSVolumeSourceFluentImpl<NFSVolumeSourceBuilder>
implements VisitableBuilder<NFSVolumeSource, NFSVolumeSourceBuilder> {
    NFSVolumeSourceFluent<?> fluent;

    public NFSVolumeSourceBuilder() {
        this(new NFSVolumeSource());
    }

    public NFSVolumeSourceBuilder(NFSVolumeSourceFluent<?> fluent) {
        this(fluent, new NFSVolumeSource());
    }

    public NFSVolumeSourceBuilder(NFSVolumeSourceFluent<?> fluent, NFSVolumeSource instance) {
        this.fluent = fluent;
        fluent.withPath(instance.getPath());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withServer(instance.getServer());
    }

    public NFSVolumeSourceBuilder(NFSVolumeSource instance) {
        this.fluent = this;
        this.withPath(instance.getPath());
        this.withReadOnly(instance.getReadOnly());
        this.withServer(instance.getServer());
    }

    @Override
    public NFSVolumeSource build() {
        NFSVolumeSource buildable = new NFSVolumeSource(this.fluent.getPath(), this.fluent.isReadOnly(), this.fluent.getServer());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NFSVolumeSourceBuilder that = (NFSVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

