/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PodSpecBuilder
extends PodSpecFluentImpl<PodSpecBuilder>
implements VisitableBuilder<PodSpec, PodSpecBuilder> {
    PodSpecFluent<?> fluent;

    public PodSpecBuilder() {
        this(new PodSpec());
    }

    public PodSpecBuilder(PodSpecFluent<?> fluent) {
        this(fluent, new PodSpec());
    }

    public PodSpecBuilder(PodSpecFluent<?> fluent, PodSpec instance) {
        this.fluent = fluent;
        fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        fluent.withContainers(instance.getContainers());
        fluent.withDnsPolicy(instance.getDnsPolicy());
        fluent.withHost(instance.getHost());
        fluent.withHostIPC(instance.getHostIPC());
        fluent.withHostNetwork(instance.getHostNetwork());
        fluent.withHostPID(instance.getHostPID());
        fluent.withImagePullSecrets(instance.getImagePullSecrets());
        fluent.withNodeName(instance.getNodeName());
        fluent.withNodeSelector(instance.getNodeSelector());
        fluent.withRestartPolicy(instance.getRestartPolicy());
        fluent.withSecurityContext(instance.getSecurityContext());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withServiceAccountName(instance.getServiceAccountName());
        fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        fluent.withVolumes(instance.getVolumes());
    }

    public PodSpecBuilder(PodSpec instance) {
        this.fluent = this;
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withContainers(instance.getContainers());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withHost(instance.getHost());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withNodeName(instance.getNodeName());
        this.withNodeSelector(instance.getNodeSelector());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withSecurityContext(instance.getSecurityContext());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public PodSpec build() {
        PodSpec buildable = new PodSpec(this.fluent.getActiveDeadlineSeconds(), this.fluent.getContainers(), this.fluent.getDnsPolicy(), this.fluent.getHost(), this.fluent.isHostIPC(), this.fluent.isHostNetwork(), this.fluent.isHostPID(), this.fluent.getImagePullSecrets(), this.fluent.getNodeName(), this.fluent.getNodeSelector(), this.fluent.getRestartPolicy(), this.fluent.getSecurityContext(), this.fluent.getServiceAccount(), this.fluent.getServiceAccountName(), this.fluent.getTerminationGracePeriodSeconds(), this.fluent.getVolumes());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSpecBuilder that = (PodSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

