/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DaemonSetSpecBuilder
extends DaemonSetSpecFluentImpl<DaemonSetSpecBuilder>
implements VisitableBuilder<DaemonSetSpec, DaemonSetSpecBuilder> {
    DaemonSetSpecFluent<?> fluent;

    public DaemonSetSpecBuilder() {
        this(new DaemonSetSpec());
    }

    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent) {
        this(fluent, new DaemonSetSpec());
    }

    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent, DaemonSetSpec instance) {
        this.fluent = fluent;
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
    }

    public DaemonSetSpecBuilder(DaemonSetSpec instance) {
        this.fluent = this;
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public DaemonSetSpec build() {
        DaemonSetSpec buildable = new DaemonSetSpec(this.fluent.getSelector(), this.fluent.getTemplate());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonSetSpecBuilder that = (DaemonSetSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

