/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import java.util.HashMap;
import java.util.Map;

public class IngressRuleFluentImpl<T extends IngressRuleFluent<T>>
extends BaseFluent<T>
implements IngressRuleFluent<T> {
    String host;
    VisitableBuilder<HTTPIngressRuleValue, ?> http;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public IngressRuleFluentImpl() {
    }

    public IngressRuleFluentImpl(IngressRule instance) {
        this.withHost(instance.getHost());
        this.withHttp(instance.getHttp());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public T withHost(String host) {
        this.host = host;
        return (T)this;
    }

    @Override
    public HTTPIngressRuleValue getHttp() {
        return this.http != null ? (HTTPIngressRuleValue)this.http.build() : null;
    }

    @Override
    public T withHttp(HTTPIngressRuleValue http) {
        if (http != null) {
            this.http = new HTTPIngressRuleValueBuilder(http);
            this._visitables.add(this.http);
        }
        return (T)this;
    }

    @Override
    public IngressRuleFluent.HttpNested<T> withNewHttp() {
        return new HttpNestedImpl();
    }

    @Override
    public IngressRuleFluent.HttpNested<T> withNewHttpLike(HTTPIngressRuleValue item) {
        return new HttpNestedImpl(item);
    }

    @Override
    public IngressRuleFluent.HttpNested<T> editHttp() {
        return this.withNewHttpLike(this.getHttp());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressRuleFluentImpl that = (IngressRuleFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.http != null ? !this.http.equals(that.http) : that.http != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class HttpNestedImpl<N>
    extends HTTPIngressRuleValueFluentImpl<IngressRuleFluent.HttpNested<N>>
    implements IngressRuleFluent.HttpNested<N> {
        private final HTTPIngressRuleValueBuilder builder;

        HttpNestedImpl() {
            this.builder = new HTTPIngressRuleValueBuilder(this);
        }

        HttpNestedImpl(HTTPIngressRuleValue item) {
            this.builder = new HTTPIngressRuleValueBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressRuleFluentImpl.this.withHttp(this.builder.build());
        }

        @Override
        public N endHttp() {
            return this.and();
        }
    }
}

