/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReference;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceFluent;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SubresourceReferenceBuilder
extends SubresourceReferenceFluentImpl<SubresourceReferenceBuilder>
implements VisitableBuilder<SubresourceReference, SubresourceReferenceBuilder> {
    SubresourceReferenceFluent<?> fluent;

    public SubresourceReferenceBuilder() {
        this(new SubresourceReference());
    }

    public SubresourceReferenceBuilder(SubresourceReferenceFluent<?> fluent) {
        this(fluent, new SubresourceReference());
    }

    public SubresourceReferenceBuilder(SubresourceReferenceFluent<?> fluent, SubresourceReference instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withSubresource(instance.getSubresource());
    }

    public SubresourceReferenceBuilder(SubresourceReference instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withSubresource(instance.getSubresource());
    }

    @Override
    public SubresourceReference build() {
        SubresourceReference buildable = new SubresourceReference(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getSubresource());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubresourceReferenceBuilder that = (SubresourceReferenceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

