/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceFluent;
import io.fabric8.openshift.api.model.ImageSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageSourceBuilder
extends ImageSourceFluentImpl<ImageSourceBuilder>
implements VisitableBuilder<ImageSource, ImageSourceBuilder> {
    ImageSourceFluent<?> fluent;

    public ImageSourceBuilder() {
        this(new ImageSource());
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent) {
        this(fluent, new ImageSource());
    }

    public ImageSourceBuilder(ImageSourceFluent<?> fluent, ImageSource instance) {
        this.fluent = fluent;
        fluent.withFrom(instance.getFrom());
        fluent.withPaths(instance.getPaths());
        fluent.withPullSecret(instance.getPullSecret());
    }

    public ImageSourceBuilder(ImageSource instance) {
        this.fluent = this;
        this.withFrom(instance.getFrom());
        this.withPaths(instance.getPaths());
        this.withPullSecret(instance.getPullSecret());
    }

    @Override
    public ImageSource build() {
        ImageSource buildable = new ImageSource(this.fluent.getFrom(), this.fluent.getPaths(), this.fluent.getPullSecret());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSourceBuilder that = (ImageSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

